/*
Projekt:	R-Bus-Modul8
Autor:		Jrg Plitz
Datei:		Eeprom.c
*/
/*----------------------------------------------------------------------------*/

#include <avr/io.h>
#include <avr/eeprom.h>

#include "TypeDef.h"
#include "Eeprom.h"
#include "R-Bus-Modul8.h"


/*==============================================================================
Funktion	ReadModulAddr
Liest die im EEPROM (Page 0, Byte 0) gespeicherte Modul-Adresse aus und gibt
diese als Rckgabewert zurck.
==============================================================================*/

u8 ReadModuleAddr()		//Modul-Adresse aus dem EEPROM lesen
{
	return eeprom_read_byte(kEepromAddrModuleAddr);
}
/*============================================================================*/

/*==============================================================================
Funktion	WriteModuleAddr
Schreibt die bergebene Kamera-Adresse in den internen EEPROM (Page 0, Byte 0).
Wegen der Kompatibilitt zu Schreibroutinen z.B. mit externem FRAM gibt auch 
die EEPROM-Funktion einen Wert (immer 0) zurck, da hier nichts schief gehen 
kann (es wird allerdings auch nicht zur Kontrolle zurckgelesen und verglichen).
==============================================================================*/
void WriteModuleAddr(u8 bParameter)
{
	eeprom_write_byte(kEepromAddrModuleAddr, bParameter);
}
/*============================================================================*/