/*
Projekt:	R-Bus-Modul8
Autor:		Jrg Plitz
Datei:		Timer.c
*/
/*----------------------------------------------------------------------------*/

#include <avr/io.h>
#include <avr/interrupt.h>

#include "TypeDef.h"
#include "Timer.h"
#include "R-Bus-Modul8.h"

volatile u8 bTimer10ms;
volatile u8 bTimer100ms;
 volatile u8 bTimer10msCnt;
 volatile u8 bTimer100msCnt;

volatile u8 bTimer1s;
volatile u8 bBlink;	//Bit0 = BlinkSlow, Bit1 = BlinkFast


/*------------------------------------------------------------------------------
Name:			TimerB0Init
Funktion:		Initialisierung und Konfiguration TimerB0 fr eine Zeitbasis
				alle 10ms (CTC-Mode)
------------------------------------------------------------------------------*/
void TimerB0Init()
{
	TCB0.CTRLA = 0;	//erstmal ausschalten
	TCB0.CTRLB = TCB_CNTMODE_INT_gc;	//periodic interrupt mode
	TCB0.CTRLC = 0;	//16-Bit
	TCB0.EVCTRL = 0;	//kein Event
	TCB0.INTCTRL = TCB_CAPT_bm;	//Capture-Interrupt
	TCB0.CNT = 0;
	TCB0.CCMP = kCPUClock/2/100;	//10ms = 100Hz
	TCB0.CTRLA = TCB_CLKSEL_DIV2_gc|TCB_ENABLE_bm;	//mit CLK:2 einschalten

 	bTimer10msCnt = 9;
 	bTimer100msCnt = 9;
}
//------------------------------------------------------------------------------

/************************************************************************
* ISR-Funktion: Timer0OutputCompare
************************************************************************/
ISR(TCB0_INT_vect)
{
//  	static u8 bTimer10msCnt;
//  	static u8 bTimer100msCnt;

	//in Timer-ISR aller ca 10ms
	bTimer10ms = 1;
	if (bTimer10msCnt) bTimer10msCnt--;
	else
	{
		bTimer10msCnt = 9;
		bTimer100ms = 1;
		if (bTimer100msCnt) 
		{
			bTimer100msCnt--;
		}
		else
		{
			bTimer100msCnt = 9;
			bTimer1s = 1;
		}
		if (bTimer100msCnt == 5)
		{
			bBlink |= 1<<xBlinkSlow;
		}
		else if (bTimer100msCnt == 0)
		{
			bBlink &= ~(1<<xBlinkSlow);
		}
		if (bTimer100msCnt & 0x01)
		{
			bBlink |= 1<<xBlinkFast;
		}
		else
		{
			bBlink &= ~(1<<xBlinkFast);
		}
	}
	TCB0.INTFLAGS |= TCB_OVF_bm;
	
}	//Ende ISR
