# RouteZT20 Quelle: RouteZT09
# global GrauFeld, hier Graufeld
# Quelle Tabellen: XLStw02.ino (14.05.2021)

from VariablesEd11 import *
import drawOpra25 as Draw

e       = []       #Stp[][]

# Fahrstrassen 
FCHECK  = 2   #const
FAUFBAU = 1   #const
FABBAU  = 0   #const
AufAbPr = 0   #Variable
   
#DebugFs = True     # print-Ausgaben zum Routing

#----------------------------------------------------

def DKWstate(x,y):
    global e
    Stateab = e[y][x].WState
    Statecd = e[y][x].WStcd
    
    Statecdab = (Statecd << 2) | Stateab
    
    #print('DKWstate:',Statecdab)
    return Statecdab


TK = [[[0,0,0,0] for x in range (7)] for y in range (2)]
TK[0] = [[0,0,0,0],[0,0,2,1],[2,1,0,0],[0,0,0,0],[0,5,0,4],[5,0,4,0]]           # 0 12 DKW
TK[1] = [[0,0,0,0],[0,0,0,0],[2,3,0,0],[0,0,2,3],[0,0,0,0],[5,0,6,0],[0,5,0,6]] # 1 13 DKW 
    # Index (0)         1         2         3         4         5         6
    #  Ele              4         5         6         1         2         3   

TD = [[[0,0,0,0] for x in range (7)]  for y in range (2)]     
TD[0] = [[0, 0, 0], [2, 0, 0], [0, 2, 0], [0, 0, 2], [0, 0, 0], [4, 5, 6], [0, 0, 0]] # 0 24
TD[1] = [[0, 0, 0], [0, 0, 0], [3, 2, 1], [0, 0, 0], [0, 0, 5], [0, 5, 0], [5, 0, 0]] # 1 25
    # Index (0)         1           2         3           4         5          6


TS = [[[0,0] for x in range (7)]  for y in range (10)]
TS[0] = [[0, 0], [1, 0], [0, 1], [0, 0], [4, 5]]                 # 0 8
TS[1] = [[0, 0], [0, 0], [0, 3], [3, 0], [0, 0], [0, 0], [6, 5]] # 1 9
TS[2] = [[0, 0], [1, 2], [0, 0], [0, 0], [4, 0], [0, 4]]         # 2 10
TS[3] = [[0, 0], [0, 0], [0, 0], [3, 2], [0, 0], [0, 6], [6, 0]] # 3 11
TS[4] = [[0, 0], [0, 0], [2, 1], [0, 0], [0, 5], [5, 0]]         # 4 16
TS[5] = [[0, 0], [0, 0], [2, 3], [0, 0], [0, 0], [5, 0], [0, 5]] # 5 17
TS[6] = [[0, 0], [0, 2], [2, 0], [0, 0], [0, 0], [5, 4]]         # 6 18
TS[7] = [[0, 0], [0, 0], [2, 0], [0, 2], [0, 0], [5, 6], [0, 0]] # 7 19
TS[8] = [[0, 0], [1, 2], [2, 1], [0, 0], [4, 5], [5, 4]]         # 8 12 DKW 1 An.
TS[9] = [[0, 0], [0, 0], [2, 3], [3, 2], [0, 0], [5, 6], [6, 5]] # 9 13 DKW 1 An.
#   Index  (0)     1        2       3       4       5       6
#    Ele           4        5       6       1       2       3


# index ist Ausgang Element, Folgeelement mit Index
# 4 \ / 3
# 5 --- 2
# 6 / \ 1
FK = [[0, 0], [1, 1], [1, 0], [1, -1], [ -1, -1], [ -1, 0], [ -1, 1]]
#     [0] not in use

IndexKorr = [0, 0, 0, 0, 1, 2, 3, 4, 0, 1, 2, 3, 0, 1, 0, 9, 4, 5, 6, 7, 5, 6, 7, 8, 0, 1]
      #         1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25
      #        | gerade |  Knicke   |  Weichen | DKW |  |Kr| Weichen   |Diag |Kreuz| DW  |


TG = [[0 for x in range (7)]  for y in range (10)]
TG [0] = [0, 0, 2, 0, 0, 5, 0] # 0 Gerade, 1,2,3
TG [1] = [0, 0, 1, 0, 5, 0, 0] # 1 Knick 4
TG [2] = [0, 0, 3, 0, 0, 0, 5] # 2 Knick 5
TG [3] = [0, 2, 0, 0, 0, 4, 0] # 3 Knick 6
TG [4] = [0, 0, 0, 2, 0, 6, 0] # 4 Knick 7
TG [5] = [0, 1, 0, 0, 4, 0, 0] # 5 Diagonale 20
TG [6] = [0, 0, 0, 3, 0, 0, 6] # 6 Diagonale 21
TG [7] = [0, 1, 2, 0, 4, 5, 0] # 7 Kreuzung 22
TG [8] = [0, 0, 2, 3, 0, 5, 6] # 8 Kreuzung 23
TG [9] = [0, 1, 0, 3, 4, 0, 6] # 9 Kreuzung 15 sym.


def EigenOut( Ele, FremdEin, AufAbPr,x,y):
    # Sonderform Signale: Ele = 1
    ind = IndexKorr[int(Ele)]
    EigenAus = 0
    
    
            # gerade|Knicke |Diagonale
    if Ele in [1,2,3,4,5,6,7,20,21]:
        EigenAus = TG[int(ind)][FremdEin]
        

    elif Ele in [15,22,23]:                 # Kreuzungen
        EigenAus = TG[int(ind)][FremdEin]
        if DebugFs: print('Kreuzung',Ele,'at x,y',x,y)

        try:            
            a = e[y][x].inFstr 
        except:
            print('Kreuzung',Ele,'at x,y',x,y,'ohne Textfeld')
            return 0
        else:
            if AufAbPr == FAUFBAU:
                e[y][x].inFstr = True                
            elif AufAbPr == FABBAU:
                e[y][x].inFstr = False
                
    
    elif Ele in [8,9,10,11,16,17,18,19]:    # EW
        Wpm = e[y][x].WState
        if Wpm == 0:            
            return 0
        else:            
            if AufAbPr == FAUFBAU:
                e[y][x].inFstr = True                
            elif AufAbPr == FABBAU:
                e[y][x].inFstr = False    
            
        EigenAus = TS[ind][FremdEin][Wpm-1]
        
        #print('EigenOut():',EigenAus)

    elif Ele in [24,25]:                    # DW
        Wpm = e[y][x].WState
        if Wpm == 0:
            print('DW keine Lage, Abbruch')
            return 0
        else:            
            if AufAbPr == FAUFBAU:
                e[y][x].inFstr = True                
            elif AufAbPr == FABBAU:
                e[y][x].inFstr = False  
        
        EigenAus = TD[ind][FremdEin][Wpm-1]

    elif Ele in [12,13]:                    # DKW
        if e[y][x].Lage in [4,5]:           # ein Antrieb    
            if DebugFs: print('DKW ein Antrieb')
            Wpm = e[y][x].WState
            if Wpm == 0:
                print('DKW keine Lage, Abbruch')
                return 0
            else:
                if AufAbPr == FAUFBAU:
                    e[y][x].inFstr = True                    
                elif AufAbPr == FABBAU:
                    e[y][x].inFstr = False 
                
            if Ele == 12:
                ind = 8
            else:
                ind = 9
            EigenAus = TS[ind][FremdEin][Wpm-1]    

        else:                               # zwei Antriebe
            Statecdab = DKWstate(x,y)
            if Statecdab == 0:
                print('DKW keine Lage, Abbruch')
                return 0
            else:
                if AufAbPr == FAUFBAU:
                    e[y][x].inFstr = True                    
                elif AufAbPr == FABBAU:
                    e[y][x].inFstr = False 
            
            DKWs = [5,6,9,10]       
            for i in range (len(DKWs)):
                if DKWs[i] == Statecdab:
                    if DebugFs: print('Index ist:',i,'FremdEin',FremdEin,'TKind',ind)
                    EigenAus = TK[ind][FremdEin][i]     #indent!
        
    return EigenAus

#--------------------------------------------

def Routing(x,y,Stp,Rm,canvas,ZR,SigChkF,SigChkR,Graufeld,GrayTC,LokTraceStop):
    Result    = True
    ZielSig   = ''
    Loknummer = 0

    if Proving(x,y,Stp,Rm,ZR,Graufeld):
        print('')
        print('Prüfung erfolgreich')
        Erfolg,ZielSig,Loknummer = RouteLocking(x,y,Stp,Rm,canvas,ZR,SigChkF,SigChkR,Graufeld,GrayTC,LokTraceStop)
        if Erfolg:
            print('Fahrstraße gestellt/aufgelöst')
            if ZielSig != '' and Loknummer != 0:
                print('ZLinfo Zielsignal, Loknummer:', ZielSig, Loknummer)
        else:
            Result = False
        
    else:
        Result = False
        print('Fahrstraße nicht einstellbar')

    return Result,ZielSig,Loknummer
        


def Proving(x,y,Stp,Rm,ZR,Graufeld):
    global e
    
    e       = Stp
    result  = False
    StartID = 0
    ZielID  = 0
    
    print('')
    print('Proving Start x,y', x,y)
    
    FremdEin = 0
    EigenAus = int(0)
    
    Ele = Stp[int(y)][int(x)]
    if Ele.Sel == 'S':
        StartID = Ele.LokStop
        print('proving StartID:',StartID)
        
        if Ele.N[0] == '*':
            print('Stumpfgleisende, keine Fahrstraße möglich')
            return False
        
        if Ele.FstrStart:
            ZR = Ele.FstrZR
        if Ele.ST in [30,31] and ZR == 'Zugf':
            if DebugFs: print('Sh-Signal, Zugfahrstraße nicht möglich')    
            return False
        if Ele.ST in [28,29] and ZR == 'Ranf':
            if DebugFs: print('Hp-Signal ohne Sh, Zugfahrstraße nicht möglich')
            return False
            
        print(Ele.N,Ele.ST)
        if DebugFs: print('Belegung:', Ele.inFstr)
        
        if Ele.inFstr:
            print('Fahrstraße bereits belegt')
            return False
        if Ele.FstrStart:
            if DebugFs: print('Auflösung, derzeit keine Auflösungsprüfung')
            return True
            
   # --------------------------------------------------         
       
        Sli = [30,28,26]     # nach rechts
        if Ele.ST in Sli:
            if DebugFs: print('nach rechts')
            FremdEin = 2
        else:
            Sli = [31,29,27] # nach links
            if Ele.ST in Sli:
                if DebugFs: print('nach links')
                FremdEin = 5

                        
    # Loop ------------------------------------
        cnt = 0
        Ele = 1    # Start
        
        while True:

            if Ele in [1,2,3]:              #Gerade                   
                if e[y][x].Sel == 'S':
                    if e[y][x].FstrEnde and cnt > 0:
                        if DebugFs: print('FstrEnde at',x,y)
                        result = False
                        break
                    
                    Melder = e[y][x].Rm
                    Belegt = Rm[Melder][2]
                    if ZR=='Zugf' and Belegt and cnt > 0:
                        print('Abschnitt',x,y,'Signal',e[y][x].N,'belegt')
                        print('Zugfahrt in belegtes Gleis nicht möglich')
                        result = False
                        break
                
                else:
                    if e[y][x].Sel == 't':  #Melder ohne Signal
                        Melder = e[y][x].Rm
                        Belegt = Rm[Melder][2]
                        if ZR=='Zugf' and Belegt:
                            print('Abschnitt',x,y,'belegt')
                            print('Zugfahrt in belegtes Gleis nicht möglich')
                            result = False
                            break
                    
                        try:
                            tx = e[y][x].BuddyX
                            ty = e[y][x].BuddyY
                            
                            
                            el  = e[ty][tx].Ele                    
                            
                            links  = e[ty][tx-1].Ele
                            if links != 0:
                                if DebugFs: print('links weiter',links)
                                FremdEin = 5
                            else:
                                rechts = e[ty][tx+1].Ele
                                if DebugFs: print('rechts weiter', rechts)                        
                                FremdEin = 2

                            x = tx
                            y = ty                    
                            
                        except:
                            pass

            
           
            EigenAus = EigenOut(Ele,FremdEin,FCHECK,x,y)
            #if EigenAus == 0:  # wenn ausgeführt, keine Einfahrt
            #    result = False # Stumpfgleis
            #    break

            if Ele in [15,22,23]:         #Kreuzung
                if e[y][x].inFstr:
                    print('Kreuzung mit Fstr. belegt')
                    result = False
                    break
            

            if e[y][x].Sel == 'S':               
                if EigenAus == 2:
                    if cnt > 0:
                        if e[y][x].ST in [26,28,30]:
                            if DebugFs: print('Signal ',e[y][x].N,'in Fahrtrichtung')
                            if e[y][x].ST == 30 and ZR == 'Zugf':
                                if DebugFs: print('Sh in Zugf auf Fahrt, kein brek')
                            else:    
                                if e[y][x].inFstr:
                                    result = False
                                else:                                    
                                    ZielID = e[y][x].LokStop
                                    print('proving Ziel Sig,ID:',e[y][x].N,ZielID)
                                    if ZielID == 0:
                                        result = True
                                    else:
                                        if e[y][x].Hpstate == 'Hp1':
                                            result = False
                                        else:
                                            result = True                                    
                                break
                            
                        else:
                            if DebugFs: print('Signal ',e[y][x].N,'in Gegenrichtung')
                            if e[y][x].inFstr == True:
                                print('Fstr belegt')
                                result = False
                                break                   #Abbruch
                            else:
                                if ZR == 'Ranf':
                                    if e[y][x].ST == 31 and Graufeld == 1:                                
                                        result = True
                                        break           #Rangierwendefahrt, Ende proving
                            #proving fortsetzen

                elif EigenAus == 5:
                    if cnt > 0:
                        if e[y][x].ST in [27,29,31]:
                            if DebugFs: print('Signal ',e[y][x].N,'in Fahrtrichtung')
                            if e[y][x].ST == 31 and ZR == 'Zugf':
                                if DebugFs: print('Sh in Zugf auf Fahrt, kein brek')
                            else:   
                                if e[y][x].inFstr:
                                    result = False
                                else:                                   
                                    ZielID = e[y][x].LokStop
                                    print('proving Ziel Sig,ID:',e[y][x].N,ZielID)
                                    if ZielID == 0:
                                        result = True
                                    else:
                                        if  e[y][x].Hpstate == 'Hp1':
                                            result = False
                                        else:
                                            result = True
                                break
                            
                        else:
                            if DebugFs: print('Signal ',e[y][x].N,'in Gegenrichtung')
                            if e[y][x].inFstr == True:
                                print('Fstr belegt')
                                result = False
                                break                   #Abbruch
                            else:
                                if ZR == 'Ranf':
                                    if e[y][x].ST == 30 and Graufeld == 1:                                
                                        result = True
                                        break           #Rangierwendefahrt, Ende proving
                            #proving fortsetzen
            #-----------------------------------------------------                                
                    
            
            if EigenAus == 0:
                el = e[y][x].Ele
                if el != 0:
                    n = e[y][x].N
                    if DebugFs: print('Abbruch at',n,x,y)
                    result = False
                else:
                    if DebugFs: print('Abruch at Ele',el,x,y)
                    result = True
                break

            nextX = x + FK[EigenAus][0]
            nextY = y + FK[EigenAus][1]

           
            Ele = Stp[nextY][nextX]
            try:
                Ele = Ele.Ele   #mit namespace
            except:
                pass      #ohne namespace
            
            FremdEin = EigenAus
            if EigenAus == 0:
                if DebugFs: print('Null')
                break
            x = nextX
            y = nextY
            
            cnt += 1
        #---------------------------------------------------------    
        #hier while-loop
          
    return result
                            
#--------------------------------------------------

# Fahrstraße belegen und Ausleuchten

def RouteLocking(x,y,Stp,Rm,canvas,ZR,SigChkF,SigChkR,Graufeld,GrayTC,LokTraceStop):
    global AufAbPr                   # Fahrstrassen Aufbau oder Abbau
    global e
    Erfolg    = True    #return-Werte
    ZielSig   = ''
    Loknummer = 0
    
    e = Stp

    Qs     = [0,0]
    Zielxy = [0,0]      #Check Folgesignal beim Befahren Sig. in Gegenrichtung 
    
    #print('Route Start x,y', x,y)
    Qs = [x,y]
    
    FremdEin = 0
    EigenAus = int(0)
    
    Ele = Stp[int(y)][int(x)]
    if Ele.Sel == 'S':        
        print(Ele.N,Ele.ST)
        if DebugFs: print('Belegung:', Ele.inFstr)

        print('check Abbau für ZL, GrayTC,Signal,FstrStart:',GrayTC,Ele.N,Ele.FstrStart)
        if GrayTC > 0 and Ele.FstrStart:    #nur Aufbau bei ZL, nie Abbau
            return Erfolg

        Loktrace = Ele.LokStop
        if DebugFs: print('Loktrace>>>>>>>',Loktrace)
       
        Sli = [30,28,26] # nach rechts
        if Ele.ST in Sli:
            if DebugFs: print('nach rechts')
            FremdEin = 2
        else:
            Sli = [31,29,27] # nach links
            if Ele.ST in Sli:
                if DebugFs: print('nach links')
                FremdEin = 5
                
        if Ele.FstrStart:       #  Abbau
            Color = GRAY
            WColo = WHITE
            Ele.FstrStart = False
            AufAbPr       = FABBAU
            if DebugFs: print('AufabPr',AufAbPr)
        else:                   # Aufbau
            if ZR == 'Zugf':
                Color = YELLOW
                WColo = YELLOW
            else:
                Color = BLUE
                WColo = BLUE
                
            Ele.FstrStart = True
            AufAbPr       = FAUFBAU
            if DebugFs: print('AufabPr',AufAbPr)
                
    # Loop ------------------------------------
        cnt = 0
        Ele = 1    # Start
        
        while True:

            if Ele in [1,2,3]:              #Gerade
                
                if e[y][x].Sel == 'S':
                    if DebugFs: print('Signal auf Track ',e[y][x].N)
                    fa = e[y][x].FstrStart
                    fe = e[y][x].FstrEnde
                    if DebugFs: print('Anfang,Ende:',fa,fe)

                    if AufAbPr == FAUFBAU:
                        e[y][x].LokStop = Loktrace
                        if DebugFs: print('Sig,Start Stop Loktrace>>>>>>>>x,y:',e[y][x].N,x,y,Loktrace)
                        LokTraceStop(e[y][x],x,y,False)
                    
                    Melder = e[y][x].Rm
                    Belegt = Rm[Melder][2]
                    if DebugFs: print('x,y,Belegt:',x,y,Belegt)
                    
                    if AufAbPr == FABBAU:
                        if cnt == 0:
                            ZR = e[y][x].FstrZR
                            if ZR == 'Zugf':
                                if e[y][x].Hpstate == 'Hp0':
                                    pass
                                else:
                                    SigChkF(x,y)
                                    LokTraceStop(e[y][x],x,y,True)
                                    
                            else:       #Rangierfahrt
                                if e[y][x].Shstate == 'Sh0':
                                    pass
                                else:
                                    SigChkR(x,y)                            
                                    
                            if DebugFs: print('Signal',e[y][x].N,'Anfang Fstr')    
                            if fe == True:
                                if not Belegt:     
                                    if e[y][x].FstrEndZR == 'Ranf':
                                        Draw.trackl(x,y,BLUE,canvas)
                                    else:
                                        Draw.trackl(x,y,YELLOW,canvas)
                            else:                                
                                if not Belegt:                                    
                                    Draw.trackl(x,y,Color,canvas) 
                            
                        else:       # nicht Anfang, in Fstr oder Ende
                            if DebugFs: print('Signal',e[y][x].N,'Ende Fstr')
                            if fa == True:
                                if not Belegt:     
                                    if e[y][x].FstrZR == 'Ranf':
                                        Draw.trackl(x,y,BLUE,canvas)
                                    else:
                                        Draw.trackl(x,y,YELLOW,canvas)
                            else:
                                if not Belegt:                                 
                                    Draw.trackl(x,y,Color,canvas)
                                    
                            e[y][x].Zr = [0,0]   #Auflösung bei Belegt aus
                        
                    else: # Aufbau Fstr.
                        if cnt == 0:
                            e[y][x].FstrZR = ZR
                            if ZR == 'Zugf':
                                SigChkF(x,y)
                            else:                               
                                SigChkR(x,y)
                        if not Belegt:                            
                            Draw.trackl(x,y,Color,canvas)

                elif e[y][x].Sel == 't':                    
                    Melder = e[y][x].Rm
                    print('566 melder,name:',Melder,e[y][x].N)
                    Belegt = Rm[Melder][2]
                    if not Belegt:                                 
                        Draw.trackl(x,y,Color,canvas) 
                    
                else:     # kein Signal, kein 't'
                    Draw.trackl(x,y,Color,canvas)   

                if hasattr (e[y][x],'N') and e[y][x].N[0] == ':': 
                    try:
                        tx = e[y][x].BuddyX
                        ty = e[y][x].BuddyY
                        #print('Link Buddy x,y:', tx,ty)
                        
                        
                        #print('target x,y',tx,ty,el,txt)
                        Draw.trackl(tx,ty,Color,canvas)
                        
                        links  = e[ty][tx-1].Ele
                        if links != 0:
                            if DebugFs: print('links weiter',links)
                             
                            FremdEin = 5
                        else:
                            rechts = e[ty][tx+1].Ele
                            if DebugFs: print('590 rechts weiter', rechts)
                            
                            FremdEin = 2

                        x = tx
                        y = ty                    
                        
                    except:
                        pass
                
            ColoringEle(x,y,Ele,FremdEin,WColo,Color,canvas)                     
           
            EigenAus = EigenOut(Ele,FremdEin,AufAbPr,x,y)

            if e[y][x].Sel == 'S':               
                if EigenAus == 2:
                    if e[y][x].ST in [26,28,30]:
                        if DebugFs: print('Signal ',e[y][x].N,'in Fahrtrichtung')
                        if cnt > 0:     #Zielsignal keine Sperre
                            if e[y][x].ST == 30 and ZR == 'Zugf':
                                if DebugFs: print('Sh in Zugf auf Fahrt, kein break')
                                if AufAbPr == FAUFBAU:                                                                       
                                    e[y][x].inFstr = True
                                    SigChkR(x,y)
                                else:        #Fstr. Abbau
                                    e[y][x].inFstr = False
                                    if e[y][x].Shstate == 'Sh0':
                                        pass
                                    else:
                                        SigChkR(x,y)
                               
                                e[y][x].FstrZR = ZR
                                                                
                            else:
                                if AufAbPr == FAUFBAU:
                                    e[y][x].LokStop = Loktrace
                                    if DebugFs: print('Ziel>>>>>>>>x,y:',x,y,'Sig davor:',Zielxy)
                                    e[Zielxy[1]][Zielxy[0]].Vhalbexy = [x,y]
                                    LokTraceStop(e[y][x],x,y,True)
                                    
                                    e[y][x].FstrEnde  = True
                                    e[y][x].inFstr    = False
                                    e[y][x].FstrEndZR = ZR
                                    e[y][x].Zr = Qs

                                    ZielSig   = e[y][x].N       #ZL info
                                    Loknummer = e[y][x].LokStop
                                    
                                elif AufAbPr == FABBAU:                                    
                                    e[y][x].FstrEnde  = False
                                    e[y][x].inFstr    = False
                                    
                                break                       
                    else:
                        if DebugFs: print('Signal ',e[y][x].N,'in Gegenrichtung')
                        
                        if cnt > 0:
                            if AufAbPr == FAUFBAU:
                                e[y][x].LokStop = Loktrace
                                if DebugFs: print('HpGegen>>>>>>>>x,y:',x,y)
                                if e[y][x].Rm != 0:
                                    Zielxy = [x,y] 
                                LokTraceStop(e[y][x],x,y,False)
                                
                                e[y][x].inFstr = True
                                e[y][x].FstrZR = ZR
                            else:
                                e[y][x].inFstr   = False
                                e[y][x].FstrEnde = False
                                e[y][x].Vhalbexy = [0,0]

                            if e[y][x].ST == 31 and ZR == 'Ranf' and Graufeld == 1:
                                if AufAbPr == FAUFBAU:
                                    e[y][x].FstrEnde = True                                    
                                    e[y][x].Zr = Qs
                                elif AufAbPr == FABBAU:
                                    e[y][x].FstrEnde = False
                                    e[y][x].inFstr   = False
                                    
                                break         #Rangierwendefahrt
                                
                        #weiter, kein break
                        
                elif EigenAus == 5:
                    if e[y][x].ST in [27,29,31]:
                        if DebugFs: print('Signal ',e[y][x].N,'in Fahrtrichtung')
                        if cnt > 0:     #Zielsignal keine Sperre
                            if e[y][x].ST == 31 and ZR == 'Zugf':
                                if DebugFs: print('Sh in Zugf auf Fahrt, kein brek')
                                if AufAbPr == FAUFBAU:                                 
                                    e[y][x].inFstr = True
                                    SigChkR(x,y)
                                else:       #Fstr. Abbau
                                    e[y][x].inFstr = False
                                    if e[y][x].Shstate == 'Sh0':
                                        pass
                                    else:
                                        SigChkR(x,y)
                                    
                                e[y][x].FstrZR = ZR
                                                                
                            else:    
                                if AufAbPr == FAUFBAU:
                                    e[y][x].LokStop = Loktrace
                                    if DebugFs: print('Ziel>>>>>>>>x,y:',x,y,'Sig davor:',Zielxy)
                                    e[Zielxy[1]][Zielxy[0]].Vhalbexy = [x,y]
                                    LokTraceStop(e[y][x],x,y,True)
                                    
                                    e[y][x].FstrEnde  = True
                                    e[y][x].inFstr    = False
                                    e[y][x].FstrEndZR = ZR
                                    e[y][x].Zr = Qs

                                    ZielSig   = e[y][x].N       #ZL info
                                    Loknummer = e[y][x].LokStop
                                    
                                elif AufAbPr == FABBAU:                                    
                                    e[y][x].FstrEnde  = False
                                    e[y][x].inFstr    = False
                                break                        
                    else:
                        if DebugFs: print('Signal ',e[y][x].N,'in Gegenrichtung')
                        
                        if cnt > 0:
                            if AufAbPr == FAUFBAU:
                                e[y][x].LokStop = Loktrace
                                if DebugFs: print('HpGegen>>>>>>>>x,y:',x,y)
                                LokTraceStop(e[y][x],x,y,False)
                                if e[y][x].Rm != 0:
                                    Zielxy = [x,y] 
                                e[y][x].inFstr = True                                
                                e[y][x].FstrZR = ZR
                            else:                                
                                e[y][x].inFstr   = False
                                e[y][x].FstrEnde = False
                                e[y][x].Vhalbexy = [0,0]

                            if e[y][x].ST == 30 and ZR == 'Ranf' and Graufeld == 1:
                                if AufAbPr == FAUFBAU:
                                    e[y][x].FstrEnde = True
                                    e[y][x].Zr = Qs
                                elif AufAbPr == FABBAU:
                                    e[y][x].FstrEnde = False
                                    e[y][x].inFstr   = False   
                                   
                                break         #Rangierwendefahrt

                        #weiter, kein break
        #-----------------------------------------------------------------                    

            elif e[y][x].Sel == 't':
                if cnt > 0:
                    if AufAbPr == FAUFBAU:
                        e[y][x].inFstr = True
                    else:
                        e[y][x].inFstr = False
                #weiter, kein break
                        
        #-----------------------------------------------------                                
                    
            #print('EigenAus:',EigenAus)
            if EigenAus == 0:
                if DebugFs: print('Abbruch at x,y',x,y)
                Erfolg = False
                break

            nextX = x + FK[EigenAus][0]
            nextY = y + FK[EigenAus][1]

            #print('next x,y:',nextX,nextY)
            Ele = Stp[nextY][nextX]
            try:
                Ele = Ele.Ele   #mit namespace
            except:
                pass            #ohne namespace
            #print('Ele:',Ele)

            FremdEin = EigenAus
            if EigenAus == 0:
                if DebugFs: print('Null')
                Erfolg = False
                break
            x = nextX
            y = nextY
            
            cnt += 1
            
        #Locking, while end (break)
    return Erfolg,ZielSig,Loknummer

            
#----------------------------------------------------------

def ColoringEle(x,y,Ele,FremdEin,WColo,Color,canvas):
    
    if Ele in [8,9,10,11]:        #DW Diagonalweichen
        SwStand = e[y][x].WState
        Draw.DiagonalStandColor(x,y,Ele,SwStand,WColo,canvas)
        
    elif Ele in [16,17,18,19]:      #EW
        SwStand = e[y][x].WState
        Draw.SwitchEWColor(x,y,Ele,SwStand,WColo,canvas)

    elif Ele in [20,21]:            #Verbinder Diagonal
        Draw.TurnoutLong(x,y,Ele & 0x03,Color,canvas)

    elif Ele in [4,5,6,7]:          #Knicke
        Draw.TurnoutPos(x,y,Ele,Color,canvas)

    elif Ele == 15:                 #sym. Kreuzung
        if FremdEin in [1,4]:
            Draw.TurnoutLong(x,y,0,Color,canvas)
        else:
            Draw.TurnoutLong(x,y,3,Color,canvas)

    elif Ele in [22,23]:            #Kreuzungen
        if FremdEin in [2,5]:
            Draw.TurnoutDir(x,y,2,Color,canvas)
            Draw.TurnoutDir(x,y,0,Color,canvas)
        elif Ele == 22:
            Draw.TurnoutPos(x,y,0,Color,canvas)
            Draw.TurnoutPos(x,y,2,Color,canvas)
        elif Ele == 23:
            Draw.TurnoutPos(x,y,1,Color,canvas)
            Draw.TurnoutPos(x,y,3,Color,canvas)                        
                

    elif Ele in [24,25]:            #Doppelweichen
        State = e[y][x].WState
        if DebugFs: print('DW State:',State)
        Draw.SwitchDWColor(x,y,Ele,State,WColo,canvas)

    elif Ele in [12,13]:            #DKW
        if e[y][x].Lage in [4,5]:
            if DebugFs: print('---------------DKW mit einem Antrieb')
            State = e[y][x].WState
            Draw.SwitchDKW1AnColor(x,y,Ele,State,WColo,FremdEin,canvas)
            
        else:                   #DKW zwei Antriebe
            Statecdab = DKWstate(x,y)
            Sab = Statecdab & 0x03
            Scd = Statecdab >> 2
            Draw.DKWabcolor(x,y,Ele,Sab,WColo,canvas)
            Draw.DKWcdcolor(x,y,Ele,Scd,WColo,canvas)
            if DebugFs: print('DKWstate:',Statecdab)
#-------------------------------------------------------
