# drawOpra25.py Quelle: drawOpra24.py und Claus drawOp21.py

from VariablesEd11 import *

CanvasObjects = { }

def resetCanvasObjects():
    global CanvasObjects
    CanvasObjects = { }
  

def circle(canvas, color, center, radius):
    r = radius-1
    key = "circle"+str(color)+str(center)+str(radius)
    if key in CanvasObjects:
        canvas.tag_raise(CanvasObjects[key])
    else:
        value = canvas.create_oval(( (center[0]-r, center[1]-r), (center[0]+r, center[1]+r) ), fill=color, outline=color)
        CanvasObjects[key] = value

def line(canvas, color, start_pos, end_pos, width=1):
    key = "line"+str(color)+str(start_pos)+str(end_pos)+str(width)
    if key in CanvasObjects:
        canvas.tag_raise(CanvasObjects[key])
    else:
        value = canvas.create_line(start_pos, end_pos, width=width, fill=color)
        CanvasObjects[key] = value

def rect(canvas, color, rt):
    key = "rect"+str(color)+str(rt)
    if key in CanvasObjects:
        canvas.tag_raise(CanvasObjects[key])
    else:
        value = canvas.create_rectangle((rt[0]), (rt[0][0]+rt[1][0]-1, rt[0][1]+rt[1][1]-1), fill=color, outline=color)
        CanvasObjects[key] = value

def polygon(canvas, color, points):
    key = "polygon"+str(color)+str(points)
    if key in CanvasObjects:
        canvas.tag_raise(CanvasObjects[key])
    else:
        value = canvas.create_polygon(points, fill=color, outline=color)
        CanvasObjects[key] = value

def text(canvas, color, pos, font, text, center=False):
    #print('###### canvas object count = ', len(canvas.find_all()), len(CanvasObjects))
    if(center==True):
        pos = (pos[0]-int(font.measure(text)/2), pos[1]-int(font.metrics()['linespace']/2))
    key = "text"+str(color)+str(pos)+str(font)+str("")+str(center)
    if key in CanvasObjects:
        canvas.delete(CanvasObjects[key])
    value = canvas.create_text(pos, text=text, fill=color, anchor="nw", font=font)
    CanvasObjects[key] = value

def font_text_extent(font, text):
    return (font.measure(text), font.metrics()['linespace'])

#-----------------------------------------------------------

from typing import Optional

SerialIO: Optional["SerialIO_Class"] = None

def SetSerialIO(SerialIOobj):
    
    global SerialIO
    SerialIO = SerialIOobj
    #print('draw >>>>>>>>>>>SerialIO:',type(SerialIO))

#-----------------------------------------------------------

def EleDraw(x, y, Ele, option, canvas):
    #print('ele:',Ele)
    if (Ele >= 1) and (Ele <= 3):           # Gleis
        track(x,y,canvas)
        trackl(x,y,GRAY,canvas)
        trackedge(x,y,canvas,Ele)

    elif (Ele >= 4) and (Ele <= 7):         # Knicke
        kink(x,y,Ele & 3,canvas)
        arrow(x,y,Ele & 3,canvas)
        TurnoutPos(x,y,Ele,GRAY,canvas)
    elif (Ele >= 16) and (Ele <= 19):       # Weiche einfach
        DrawTurnout(x,y,Ele,option,canvas)

    elif (Ele == 24):                       # Doppelweichen
        DWeiche24(x,y,canvas)
    elif (Ele == 25):
        DWeiche25(x,y,canvas)

    elif (Ele == 26) or (Ele == 27):        # Hp+Sh
        sigScreen(x,y,Ele,canvas)
        ShHscreen(x,y,Ele,canvas)
        StandSig(x,y,Ele,canvas)

    elif (Ele == 28) or (Ele == 29):        # Hp
        sigScreen(x,y,Ele,canvas)
        StandSig(x,y,Ele,canvas)

    elif (Ele == 30) or (Ele == 31):        # Sh
        ShScreen(x,y,Ele,canvas)
        StandSig(x,y,Ele,canvas)

    elif (Ele == 12) or (Ele == 22):        # DKW und Kreuzung
        DKW(x,y,Ele & 3,canvas)
    elif (Ele == 13) or (Ele == 23):
        DKW(x,y,Ele & 3,canvas)

    elif (Ele >= 8) and (Ele <= 11):        # Weiche diagonal
        DiagoWeiche(x,y,Ele,canvas)

    elif (Ele == 15):                       # sym. Kreuzung
        SymKr(x,y,canvas)
    elif (Ele == 20) or (Ele == 21):        # Diagonale
        TrackSlant(x,y,Ele & 3,canvas)
        TurnoutLong(x,y,Ele & 3,GRAY,canvas)
    return




def checkS(va):                # Gleissperre, Flag noch merken
    c=0
    if isinstance(va,str):
        if va[0]=='G':
            c= int (va[1]+va[2])
    return(c)

def TrPlan(line,canvas):
    j=0
    while j < ElanzX:
        b =checkS (StpM[line][j])
        if b:
            StpM[line][j]=b
        EleDraw(j,line,int(StpM[line][j]),0,canvas)

        j = j+1
    return
#-------------------------------------------------


def SymKr(x,y,canvas):
    TrackSlant(x,y,0,canvas)
    TrackSlant(x,y,3,canvas)
    TurnoutLong(x,y,0,GRAY,canvas)
    TurnoutLong(x,y,3,GRAY,canvas)
    return

def TrackSlant(x,y,corner,canvas):   #Diagonale
    ex = x * elx + offsx
    ey = y * ely + offsy

    px1=elx;  py1=ely
    px2=elx;  py2=ely-7
    px3=7;    py3=0
    px4=0;    py4=0
    px5=0;    py5=7
    px6=elx-7;py6=ely

    if ((corner == 1) or (corner == 3)):
        px1=0;
        px2=7;    py2=ely
        px3=elx;  py3=7
        px4=elx;  py4=0
        px5=elx-7;py5=0
        px6=0;    py6=ely-7
    polygon(canvas,BLACK,[(px1+ex,py1+ey),(px2+ex,py2+ey),(px3+ex,py3+ey),
                          (px4+ex,py4+ey),(px5+ex,py5+ey),(px6+ex,py6+ey)])
    return


def TurnoutLong(x,y,corner,color,canvas):  # Ausleuchtung Diagonale
    cx = x * elx + (elx/2)
    cy = y * ely + (ely/2)
    cx = cx + offsx
    cy = cy + offsy

    eckx = elx/2; ecky = ely/2
    px1=eckx-52;  py1=ecky-32
    px2=eckx-15;  py2=ecky-8
    px3=eckx-13;  py3=ecky-12
    px4=eckx-50;  py4=ecky-35

    if (corner == 1):
        py1 = -py1; py2 = -py2; py3 = -py3; py4 = -py4
    elif (corner == 2):
        py1 = -py1; py2 = -py2; py3 = -py3; py4 = -py4
        px1 = -px1; px2 = -px2; px3 = -px3; px4 = -px4
    elif (corner == 3):
        px1 = -px1; px2 = -px2; px3 = -px3; px4 = -px4

    a1 = round(px1+cx); b1 = round(py1+cy)
    a2 = round(px2+cx); b2 = round(py2+cy)
    a3 = round(px3+cx); b3 = round(py3+cy)
    a4 = round(px4+cx); b4 = round(py4+cy)

    polygon(canvas,(color),[(a1,b1),(a2,b2),(a3,b3),(a4,b4)])

    return


def DKW (x,y, corner,canvas):
    TrackSlant(x,y,corner,canvas)
    track(x,y,canvas)
    cx = x * elx + (elx/2)
    cy = y * ely + (ely/2)
    cx = cx + offsx
    cy = cy + offsy

    #print('corner:',corner)

    if (corner == 0) or (corner == 2):
        TurnoutDir(x,y,2,GRAY,canvas)
        TurnoutPos(x,y,2,GRAY,canvas)
        TurnoutDir(x,y,0,GRAY,canvas)
        TurnoutPos(x,y,0,GRAY,canvas)
    else:
        TurnoutDir(x,y,3,GRAY,canvas)
        TurnoutPos(x,y,3,GRAY,canvas)
        TurnoutDir(x,y,1,GRAY,canvas)
        TurnoutPos(x,y,1,GRAY,canvas)
    if corner == 1:               #todo: trennung dkw-Kreuzung
        line(canvas,DGRAY,(round(-7+cx),round(-7+cy)),(round(7+cx),round(-14+cy)),3)
        line(canvas,DGRAY,(round(-7+cx),round(14+cy)),(round(7+cx),round(7+cy)),3)
    if corner == 0:
        line(canvas,DGRAY,(round(-7+cx),round(-14+cy)),(round(7+cx),round(-9+cy)),3)
        line(canvas,DGRAY,(round(-7+cx),round(7+cy)),(round(7+cx),round(16+cy)),3)

    return

def DiagoWeiche(x,y,Ele,canvas):   # DrawSTurnout, Element 8,9,10,11

    corner = Ele & 3
    TrackSlant(x,y,corner,canvas)
    TrackHLine(x,y,corner,canvas)
    DrawDiagonalStand(x,y,Ele,0,canvas)   # Lage unbekannt
    return


def TrackHLine(x,y,corner,canvas):
    cx = x * elx + (elx/2)
    cy = y * ely + (ely/2)
    cx = cx + offsx
    cy = cy + offsy
    px1 = cx -elx/2; py1 = cy -TRACK/2

    if ((corner == 2) or (corner == 3)):
        px1 = cx

    rect(canvas,BLACK,[(int(px1),int(py1)),(int(elx/2),TRACK)])
    return


def trackedge(x,y,canvas,Ele):
    if Ele == 2:
        rect(canvas,LGRAY,[(x*elx+offsx+1,y*ely+offsy+4),(elx-1,10)])
    elif Ele == 3:
        rect(canvas,LGRAY,[(x*elx+offsx+1,y*ely+offsy+28),(elx-1,10)])

#-------------------------------------------------------------------

def DWeiche24(x,y,canvas):
    track(x,y,canvas)
    arrow(x,y,2,canvas)
    arrow(x,y,3,canvas)
    TurnoutDir(x,y,2,GRAY,canvas)
    TurnoutPos(x,y,2,GRAY,canvas)
    TurnoutPos(x,y,3,GRAY,canvas)
    return

def DWeiche25(x,y,canvas):
    track(x,y,canvas)
    arrow(x,y,1,canvas)
    arrow(x,y,0,canvas)
    TurnoutDir(x,y,1,GRAY,canvas)
    TurnoutPos(x,y,0,GRAY,canvas)
    TurnoutPos(x,y,1,GRAY,canvas)
    return

def SwitchDWColor(x,y,Ele,State,color,canvas):

    if State == 1:
        if Ele == 24:
            TurnoutPos(x,y,2,color,canvas)
        else:
            TurnoutPos(x,y,1,color,canvas)
            
    elif State == 2:
        if Ele == 24:
            TurnoutDir(x,y,2,color,canvas)
        else:
            TurnoutDir(x,y,1,color,canvas)

    elif State == 3:
        if Ele == 24:
            TurnoutPos(x,y,3,color,canvas)
        else:
            TurnoutPos(x,y,0,color,canvas)
            

def DrawDWStand(x,y,Ele,Adr,Option,State,canvas):

    #Option 1: Lage Antrieb Spitze, 2: Lage 2. Antrieb
    print('x,y,Ele,Adr,Option,State:',x,y,Ele,Option,State)

    swp0 = 0
    swp1 = 0
    if Option == 1:
        swp0 = 1
    elif Option == 2:
        swp1 = 1
    elif Option == 3:
        swp0 = 1
        swp1 = 1

    if State == 0:                                       # 1.Klick ==
        State = 2
        if Ele == 24:
            TurnoutDir(x,y,2,WHITE,canvas)
        else:
            TurnoutDir(x,y,1,WHITE,canvas)
        SerialIO.Wswitch(Adr,swp0)
        SerialIO.Wswitch(-(Adr+1),swp1)

    elif State == 1:
        State = 2
        if Ele == 24:
            TurnoutPos(x,y,2,DGRAY,canvas)
            TurnoutDir(x,y,2,WHITE,canvas)
        else:
            TurnoutPos(x,y,1,DGRAY,canvas)
            TurnoutDir(x,y,0,WHITE,canvas)
        SerialIO.Wswitch(Adr,swp0)
        SerialIO.Wswitch(-(Adr+1),swp1)

    elif State == 2:
        State = 3
        if Ele == 24:
            TurnoutDir(x,y,2,DGRAY,canvas)
            TurnoutPos(x,y,3,WHITE,canvas)
            SerialIO.Wswitch(Adr,swp0)
            SerialIO.Wswitch(Adr+1,swp1)
        else:
            TurnoutDir(x,y,1,DGRAY,canvas)                   # 2.Klick \\
            TurnoutPos(x,y,0,WHITE,canvas)
            SerialIO.Wswitch(-Adr,swp0)

    elif State == 3:
        State = 1
        if Ele == 24:
            TurnoutPos(x,y,3,DGRAY,canvas)
            TurnoutPos(x,y,2,WHITE,canvas)
            SerialIO.Wswitch(-Adr,swp0)
        else:
            TurnoutPos(x,y,0,DGRAY,canvas)                  # 3.Klick //
            TurnoutPos(x,y,1,WHITE,canvas)
            SerialIO.Wswitch(Adr,swp0)
            SerialIO.Wswitch(Adr+1,swp1)

    print('Lage manuell:',State)
    return State
#--------------------------------------------------------------------

# DW durch Fweg schalten

def DWnewState(x,y,Ele,Adr,newState,swp0,swp1,canvas):

    if Ele == 24:               #Lösche alten drawState
        TurnoutPos(x,y,3,DGRAY,canvas)
        TurnoutPos(x,y,2,DGRAY,canvas)
        TurnoutDir(x,y,2,DGRAY,canvas)
    else:
        TurnoutPos(x,y,0,DGRAY,canvas)
        TurnoutPos(x,y,1,DGRAY,canvas)
        TurnoutDir(x,y,1,DGRAY,canvas)


    if newState == 1:
        if Ele == 24:
            #TurnoutPos(x,y,3,DGRAY,canvas)
            TurnoutPos(x,y,2,WHITE,canvas)
            SerialIO.Wswitch(-Adr,swp0)
        else:
            #TurnoutPos(x,y,0,DGRAY,canvas)
            TurnoutPos(x,y,1,WHITE,canvas)
            SerialIO.Wswitch(Adr,swp0)
            SerialIO.Wswitch(Adr+1,swp1)

    elif newState == 2:
        if Ele == 24:
            #TurnoutPos(x,y,2,DGRAY,canvas)
            TurnoutDir(x,y,2,WHITE,canvas)
        else:
            #TurnoutPos(x,y,1,DGRAY,canvas)
            TurnoutDir(x,y,0,WHITE,canvas)
        SerialIO.Wswitch(Adr,swp0)
        SerialIO.Wswitch(-(Adr+1),swp1)

    elif newState == 3:
        if Ele == 24:
            #TurnoutDir(x,y,2,DGRAY,canvas)
            TurnoutPos(x,y,3,WHITE,canvas)
            SerialIO.Wswitch(Adr,swp0)
            SerialIO.Wswitch(Adr+1,swp1)
        else:
            #TurnoutDir(x,y,1,DGRAY,canvas)
            TurnoutPos(x,y,0,WHITE,canvas)
            SerialIO.Wswitch(-Adr,swp0)





#---------------------------------------------------------------------
def DrawSwDKW(x,y,Ele,Adr,Option,State,Statecd,DKWside,canvas):

    print('DKW x,y,Ele,Adr,Option,State,Stcd:',x,y,Ele,Adr,Option,State,Statecd)
    if Option >= 4:                                 #DKW mit einem Antrieb
        State = DrawSw1Adkw(x,y,Ele,Adr,Option,State,canvas)
        return State, Statecd

    Gerade = 1
    Bogen  = 2

    swpab = 0
    swpcd = 0
    if Option == 1:
        swpab = 1
    elif Option == 2:
        swpcd = 1
    elif Option == 3:
        swpab = 1
        swpcd = 1

    print('DKWside',DKWside)

    if State == 0:
        State   = Gerade
        Statecd = Gerade
        TurnoutDir(x,y,0,WHITE,canvas)
        SerialIO.Wswitch(Adr,swpab)
        TurnoutDir(x,y,2,WHITE,canvas)
        SerialIO.Wswitch(Adr+1,swpcd)

    else:
        if DKWside == 'c/d':            #! means a/b
            if State == Gerade:
                State = Bogen
                if Ele == 13:
                    TurnoutDir(x,y,1,GRAY,canvas)
                    TurnoutPos(x,y,1,WHITE,canvas)
                else:
                    TurnoutDir(x,y,1,GRAY,canvas)
                    TurnoutPos(x,y,0,WHITE,canvas)
                SerialIO.Wswitch(-Adr,swpab)

            elif State == Bogen:
                State = Gerade
                if Ele == 13:
                    TurnoutPos(x,y,1,GRAY,canvas)
                    TurnoutDir(x,y,1,WHITE,canvas)
                else:
                    TurnoutPos(x,y,0,GRAY,canvas)
                    TurnoutDir(x,y,1,WHITE,canvas)
                SerialIO.Wswitch(Adr,swpab)

        else:                                   # c/d, means a/b
            if Statecd == Gerade:
                Statecd = Bogen
                if Ele == 13:
                    TurnoutPos(x,y,3,WHITE,canvas)
                    TurnoutDir(x,y,3,GRAY,canvas)
                else:
                    TurnoutPos(x,y,2,WHITE,canvas)
                    TurnoutDir(x,y,3,GRAY,canvas)
                SerialIO.Wswitch(-(Adr+1),swpcd)

            elif Statecd == Bogen:
                Statecd = Gerade
                if Ele == 13:
                    TurnoutPos(x,y,3,GRAY,canvas)
                    TurnoutDir(x,y,3,WHITE,canvas)
                else:
                    TurnoutPos(x,y,2,GRAY,canvas)
                    TurnoutDir(x,y,3,WHITE,canvas)
                SerialIO.Wswitch(Adr+1,swpcd)

    print('Lage ab:',State)
    print('Lage cd:',Statecd)

    return State,Statecd

#-----------------------------------------------------------------
# DKW coloring
def DKWabcolor(x,y,Ele,Sab,color,canvas):
    #print('coloring ab',Sab)
    Gerade = 1
    Bogen  = 2
    if Sab == Gerade:        
        if Ele == 13:
            TurnoutDir(x,y,1,color,canvas)            
        else:
            TurnoutDir(x,y,1,color,canvas)
            
    elif Sab == Bogen:        
        if Ele == 13:
            TurnoutPos(x,y,1,color,canvas)            
        else:
            TurnoutPos(x,y,0,color,canvas)
            


def DKWcdcolor(x,y,Ele,Scd,color,canvas):
    #print('coloring cd',Scd)
    Gerade = 1
    Bogen  = 2
    if Scd == Gerade:        
        if Ele == 13:            
            TurnoutDir(x,y,3,color,canvas)
        else:            
            TurnoutDir(x,y,3,color,canvas)        

    elif Scd == Bogen:        
        if Ele == 13:
            TurnoutPos(x,y,3,color,canvas)            
        else:
            TurnoutPos(x,y,2,color,canvas)

#-----------------------------------------------------------------
#DKW 1Antrieb coloring

def SwitchDKW1AnColor(x,y,Ele,State,Wcolo,FremdEin,canvas):
    Gerade = 1
    
    print('---------------call DKW1Aimpress()')
    DKW1Aimpress(x,y,Ele,Wcolo,canvas)
          
    if  Ele == 12:
        if State == Gerade:
            if FremdEin in [2,5]:
                TurnoutDir(x,y,0,Wcolo,canvas)
                TurnoutDir(x,y,3,Wcolo,canvas)
            elif FremdEin in [1,4]:
                TurnoutPos(x,y,0,Wcolo,canvas)
                TurnoutPos(x,y,2,Wcolo,canvas)
                
        else:   # Bogen
            if FremdEin in [2,4]:
                TurnoutPos(x,y,0,Wcolo,canvas)
                TurnoutDir(x,y,3,Wcolo,canvas)
            elif FremdEin in [1,5]:
                TurnoutDir(x,y,1,Wcolo,canvas)
                TurnoutPos(x,y,2,Wcolo,canvas)

            
    else:       #Ele 13
        if State == Gerade:
            if FremdEin in [2,5]:
                TurnoutDir(x,y,1,Wcolo,canvas)
                TurnoutDir(x,y,3,Wcolo,canvas)
            elif FremdEin in [3,6]:
                TurnoutPos(x,y,1,Wcolo,canvas)
                TurnoutPos(x,y,3,Wcolo,canvas)
                
        else:   # Bogen
            if FremdEin in [2,6]:
                TurnoutPos(x,y,1,Wcolo,canvas)
                TurnoutDir(x,y,3,Wcolo,canvas)
            elif FremdEin in [3,5]:
                TurnoutDir(x,y,1,Wcolo,canvas)
                TurnoutPos(x,y,3,Wcolo,canvas)
 

def DKW1Aimpress(x,y,Ele,Wcolo,canvas):         #unbefahrene Zweige grau
    print('DKW1A',Wcolo)
    if Wcolo == YELLOW or Wcolo == BLUE:
        col = GRAY
    else:
        col = WHITE
        
    if Ele == 12:
        TurnoutDir(x,y,2,col,canvas)
        TurnoutPos(x,y,2,col,canvas)
        TurnoutDir(x,y,0,col,canvas)
        TurnoutPos(x,y,0,col,canvas)
    else:
        TurnoutDir(x,y,3,col,canvas)
        TurnoutPos(x,y,3,col,canvas)
        TurnoutDir(x,y,1,col,canvas)
        TurnoutPos(x,y,1,col,canvas)    


#-----------------------------------------------------------------

# DKW durch Fweg schalten

def statePic_ab_update(x,y,Ele,State,Adr,swpab,canvas):
    Gerade = 1
    Bogen  = 2
    if State == Gerade:
        State = Bogen
        if Ele == 13:
            TurnoutDir(x,y,1,GRAY,canvas)
            TurnoutPos(x,y,1,WHITE,canvas)
        else:
            TurnoutDir(x,y,1,GRAY,canvas)
            TurnoutPos(x,y,0,WHITE,canvas)
        SerialIO.Wswitch(-Adr,swpab)

    elif State == Bogen:
        State = Gerade
        if Ele == 13:
            TurnoutPos(x,y,1,GRAY,canvas)
            TurnoutDir(x,y,1,WHITE,canvas)
        else:
            TurnoutPos(x,y,0,GRAY,canvas)
            TurnoutDir(x,y,1,WHITE,canvas)
        SerialIO.Wswitch(Adr,swpab)
    return State


def statePic_cd_update(x,y,Ele,Statecd,Adr,swpcd,canvas):
    Gerade = 1
    Bogen  = 2
    if Statecd == Gerade:
        Statecd = Bogen
        if Ele == 13:
            TurnoutPos(x,y,3,WHITE,canvas)
            TurnoutDir(x,y,3,GRAY,canvas)
        else:
            TurnoutPos(x,y,2,WHITE,canvas)
            TurnoutDir(x,y,3,GRAY,canvas)
        SerialIO.Wswitch(-(Adr+1),swpcd)

    elif Statecd == Bogen:
        Statecd = Gerade
        if Ele == 13:
            TurnoutPos(x,y,3,GRAY,canvas)
            TurnoutDir(x,y,3,WHITE,canvas)
        else:
            TurnoutPos(x,y,2,GRAY,canvas)
            TurnoutDir(x,y,3,WHITE,canvas)
        SerialIO.Wswitch(Adr+1,swpcd)
    return Statecd


#-----------------------------------------------------------------

def DrawSw1Adkw(x,y,Ele,Adr,Option,State,canvas):
    print('DKW ein Antrieb, Option:',Option)
    Gerade = 1
    Bogen  = 2

    ex = x * elx + offsx + elx/2
    ey = y * ely + offsy + ely/2
    cr = 5

    swap = 0
    if Option == 5:
        swap = 1

    if State == 0:
        TurnoutDir(x,y,0,WHITE,canvas)
        TurnoutDir(x,y,2,WHITE,canvas)
        if Ele == 13:
            TurnoutPos(x,y,1,WHITE,canvas)
            TurnoutPos(x,y,3,WHITE,canvas)
        else:
            TurnoutPos(x,y,0,WHITE,canvas)
            TurnoutPos(x,y,2,WHITE,canvas)
        State = Gerade

    elif State == Gerade:
        circle(canvas,WHITE,(int(ex),int(ey)),cr)
        State = Bogen
        Adr = -Adr

    elif State == Bogen:
        circle(canvas,BLACK,(int(ex),int(ey)),cr)
        State = Gerade

    SerialIO.Wswitch(Adr,swap)

    return State


def DrawDKW1Astand(x,y,Ele,SwStand,canvas): # nur Zeichnen in Fweg, kein Schalten
    #wie DrawSwitchStand() EW
    print('Zeichne DKW 1A in Fweg', x,y,Ele,SwStand)

    ex = x * elx + offsx + elx/2
    ey = y * ely + offsy + ely/2
    cr = 5
    
    if SwStand == 0:
        TurnoutDir(x,y,0,WHITE,canvas)
        TurnoutDir(x,y,2,WHITE,canvas)
        if Ele == 13:
            TurnoutPos(x,y,1,WHITE,canvas)
            TurnoutPos(x,y,3,WHITE,canvas)
        else:
            TurnoutPos(x,y,0,WHITE,canvas)
            TurnoutPos(x,y,2,WHITE,canvas)    

    elif SwStand == 1: # gerade
        circle(canvas,BLACK,(int(ex),int(ey)),cr)        

    elif SwStand == 2: # Bogen
        circle(canvas,WHITE,(int(ex),int(ey)),cr)

#-------------------------------------------------------------------

def DrawTurnout(x,y,Ele,Glsp,canvas):   # normale Weiche mit Lage init.
    #Weiche komplett Initialisierung, ohne Lage
    corner = Ele & 0x03
    track(x,y,canvas)
    if Glsp > 1:
        arrowglsp(x,y,corner,canvas)
    else:
        arrow(x,y,corner,canvas)
    DrawSwitchStand(x,y,Ele,0,canvas);    # Lage unbekannt (0)
    return


def DrawSwitchStand(x, y, Ele, SwStand,canvas):
    #Weichen Lage, ohne oder mit Lage
    corner = Ele & 0x03

    if (SwStand == 0):
        TurnoutDir(x,y, corner, GRAY,canvas)
        TurnoutPos(x,y, corner, GRAY,canvas)
    elif (SwStand == 1):
        TurnoutPos(x,y, corner, GRAY,canvas)
        TurnoutDir(x,y, corner, WHITE,canvas)
    elif (SwStand == 2):
        TurnoutDir(x,y, corner, GRAY,canvas)
        TurnoutPos(x,y, corner, WHITE,canvas)
    return

def SwitchEWColor(x,y,Ele,SwStand,color,canvas):
    corner = Ele & 0x03
    if SwStand == 1:
        TurnoutDir(x,y, corner, color,canvas)
    elif SwStand == 2:
        TurnoutPos(x,y, corner, color,canvas)
        

def DrawDiagonalStand(x,y,w811,SwStand,canvas):

    w811 = int(w811)
    cor1 = 0; cor2 = 0

    if (w811 == 8):
        cor1 = 2; cor2 = 2
    elif (w811 == 9):
        if (SwStand == 2):
            cor1 = 2; cor2 = 3
        else:
            cor1 = 3; cor2 = 2
    elif (w811 == 10):
        cor1 = 0; cor2 = 0
    elif (w811 == 11):
        if (SwStand == 2):
            cor1 = 0; cor2 = 1
        else:
            cor1 = 1; cor2 = 0

    if (SwStand == 0):
        TurnoutDir(x,y, cor2, GRAY,canvas)
        TurnoutPos(x,y, cor1, GRAY,canvas)
    elif (SwStand == 1):
        TurnoutPos(x,y, cor1, WHITE,canvas)     #gray
        TurnoutDir(x,y, cor2, GRAY,canvas)      #white
    elif (SwStand == 2):
        TurnoutDir(x,y, cor1, WHITE,canvas)     #gray
        TurnoutPos(x,y, cor2, GRAY,canvas)      #white
    return


def DiagonalStandColor(x,y,w811,SwStand,color,canvas):
    
    if (w811 == 8):
        cor1 = 2; 
    elif (w811 == 9):
        if (SwStand == 2):
            cor1 = 2; 
        else:
            cor1 = 3; 
    elif (w811 == 10):
        cor1 = 0; 
    elif (w811 == 11):
        if (SwStand == 2):
            cor1 = 0; 
        else:
            cor1 = 1; 

    if (SwStand == 1):
        TurnoutPos(x,y, cor1, color,canvas)     #gray
        
    elif (SwStand == 2):
        TurnoutDir(x,y, cor1, color,canvas)     #gray
        


def TurnoutDir(x,y, turn, color,canvas):  # Lageinfo: Gerade

    cx = x * elx + (elx/2)
    cy = y * ely + (ely/2)
    cx = cx + offsx
    cy = cy + offsy

    if (turn == 0) or (turn == 1):
        px1= cx + elx/2 - 18; py1= cy - TRACK/2 + 3;
        px2 = 18; py2 = 3                              #zuvor 5
    elif (turn == 2) or (turn == 3):
        px1= cx - elx/2 +1; py1= cy - TRACK/2 + 3;
        px2 = 18; py2 = 3                              #zuvor 5

    rect(canvas,(color),[(int(px1),int(py1)),(int(px2),int(py2))])
    return


def TurnoutPos(x,y, Ele, color,canvas):  # Lageinfo: Bogen

    turn = Ele & 0x03
    cx = x * elx + (elx/2)
    cy = y * ely + (ely/2)
    cx = cx + offsx
    cy = cy + offsy

    eckx = elx/2; ecky = ely/2
    px1=eckx-8;  py1=ecky-3
    px2=eckx-7;  py2=ecky-7
    px3=eckx-16; py3=ecky-12
    px4=eckx-18; py4=ecky-8

    if (turn == 1):
        py1 = -py1; py2 = -py2; py3 = -py3; py4 = -py4
    elif (turn == 2):
        py1 = -py1; py2 = -py2; py3 = -py3; py4 = -py4
        px1 = -px1; px2 = -px2; px3 = -px3; px4 = -px4
    elif (turn == 3):
        px1 = -px1; px2 = -px2; px3 = -px3; px4 = -px4

    a1 = round(px1+cx); b1 = round(py1+cy)
    a2 = round(px2+cx); b2 = round(py2+cy)
    a3 = round(px3+cx); b3 = round(py3+cy)
    a4 = round(px4+cx); b4 = round(py4+cy)

    polygon(canvas,(color),[(a1,b1),(a2,b2),(a3,b3),(a4,b4)])
    return


def kink(x,y,corner,canvas):
    #Gleis horizontal mit Anschnitt
    cx = int(x * elx + (elx/2))
    cy = int(y * ely + (ely/2))
    cx = int(cx + offsx)
    cy = int(cy + offsy)
    px1=int(    12); py1=int(+TRACK/2)
    px2=int(    -7); py2=int(-TRACK/2)
    px3=int(-elx/2); py3=int(-TRACK/2)
    px4=int(   px3); py4=int(+TRACK/2)

    if (corner == 1):
        py1=-py1; py2=-py2; py3= -py3; py4=-py4;
    elif (corner==2):
        py1=-py1; py2=-py2; py3= -py3; py4=-py4;
        px1=-px1; px2=-px2; px3= -px3; px4=-px4;
    elif (corner==3):
        px1=-px1; px2=-px2; px3= -px3; px4=-px4;

    polygon(canvas,BLACK,[(px1+cx,py1+cy),(px2+cx,py2+cy),(px3+cx,py3+cy),(px4+cx,py4+cy)])
    return

def arrow(x,y,corner,canvas):
    #Gleis abzweigend mit Anschnitt
    cx = int(x * elx + (elx/2))
    cy = int(y * ely + (ely/2))
    cx = int(cx + offsx)
    cy = int(cy + offsy)
    px1=int(elx/2);py1=int(ely/2)
    px2=int(px1);  py2=int(py1-7)
    px3=12;   py3=9/2
    px4=-10;  py4=int(py3)
    px5=int(px1-7);py5=int(py1)

    if (corner == 1):
        py1=-py1; py2=-py2; py3= -py3; py4=-py4; py5=-py5
    elif (corner==2):
        py1=-py1; py2=-py2; py3= -py3; py4=-py4; py5=-py5
        px1=-px1; px2=-px2; px3= -px3; px4=-px4; px5=-px5
    elif (corner==3):
        px1=-px1; px2=-px2; px3= -px3; px4=-px4; px5=-px5
    a1 = round(px1+cx); b1 = round(py1+cy)
    a2 = round(px2+cx); b2 = round(py2+cy)
    a3 = round(px3+cx); b3 = round(py3+cy)
    a4 = round(px4+cx); b4 = round(py4+cy)
    a5 = round(px5+cx); b5 = round(py5+cy)

    polygon(canvas,BLACK,[(a1,b1),(a2,b2),(a3,b3),(a4,b4),(a5,b5)])
    return


def arrowglsp(x,y,corner,canvas):
    #Gleis abzweigend mit Anschnitt
    cx = int(x * elx + (elx/2))
    cy = int(y * ely + (ely/2))
    cx = int(cx + offsx)
    cy = int(cy + offsy)
    px1=int(elx/2);py1=int(ely/2)
    px2=int(px1-7);  py2=int(py1-6)
    px3=10;   py3=4
    px4=-5;   py4=4
    px5=int(px1-8);py5=int(py1-5)

    if (corner == 1):
        py1=-py1; py2=-py2; py3= -py3; py4=-py4; py5=-py5
    elif (corner==2):
        py1=-py1; py2=-py2; py3= -py3; py4=-py4; py5=-py5
        px1=-px1; px2=-px2; px3= -px3; px4=-px4; px5=-px5
    elif (corner==3):
        px1=-px1; px2=-px2; px3= -px3; px4=-px4; px5=-px5
     
    a2 = round(px2+cx); b2 = round(py2+cy)
    a3 = round(px3+cx); b3 = round(py3+cy)
    a4 = round(px4+cx); b4 = round(py4+cy)
    a5 = round(px5+cx); b5 = round(py5+cy)

    polygon(canvas,BLACK,[(a2,b2),(a3,b3),(a4,b4),(a5,b5)])
    return

def track(x,y,canvas):
    #Gleis
    px = x*elx+offsx; py = y*ely+offsy
    rect(canvas,BLACK,[(px,py+16),(elx,9)])
    return

def trackl(x,y,col,canvas):
    #Gleis Ausleuchtung
    px = x*elx+offsx; py = y*ely+offsy
    rect(canvas,col,[(px+10,py+18),(elx-20,5)])
    return

#-----------------------------------------------------------------
def textButt(x,y,String,font,canvas):   # Text FwegButton und Schaltdec.
    cx =offsx-12 +elx/2
    cy =offsy-20 +ely/2
    text(canvas,BLACK,(x * elx+cx+10,y*ely+cy+6),font,String,True)
    return

def textButtEle(x,y,String,font,canvas):   # Text FwegButton mit Gleis
    cx =offsx-12 +elx/2
    cy =offsy-20 +ely/2
    text(canvas,BLACK,(x * elx+cx+20,y*ely+cy+6),font,String,True)
    return

def textStr(x,y,String,font,canvas):   #zunächst Elementbeschriftungen
    cx =offsx-45+elx/2
    cy =offsy+ely/2
    text(canvas,BLACK,(round(x*elx+cx),round(y*ely+cy)),font,String)
    return

def textInfo(x,y,Lp,String,Ele,font,font14,canvas):
    Lp = int(Lp)
    cx =offsx-20+elx/2
    cy =offsy+ely
    Korx = 18   #default
    Kory = 15   #15
    #print('Nele:',Ele)
    if (Ele == 1) or (Ele == 3):         # Gleis, oben
        Kory = 33
    elif (Ele == 2):                     # Gleis, unten
        Kory =  8
    elif (Ele == 24) or (Ele == 8):      # oben rechts DW, DiaW
        Korx = 22
        Kory = 2
    elif (Ele == 9):                     # unten rechts DiaW
        Korx = 22
        Kory = 26
    elif (Ele == 12) or (Ele == 10):     # DKW DiaW
        Korx = -5
        Kory = 26                        # unten links
    elif (Ele == 13) or (Ele == 25) or (Ele == 11): # DKW
        Korx = -5
        Kory = 2                         # oben links
    elif (Ele == 16) or (Ele == 19):     # Schrift oben EW
        Kory = 33
    elif (Ele == 17) or (Ele == 18):     # Schrift unten EW
        Kory =  8

    elif Ele == 0:
        #print("Beschriftung auf Ele == 0:",String)
        
        rect(canvas,WHITE,[(x*elx+offsx+1,y*ely+offsy+13),(elx-1,16)])
        text(canvas,BLACK,(x * elx+cx+20,y*ely+cy-20),font,String,True)

    if Ele >= 16 and Ele <= 19:          # Einfache Weiche
        text(canvas,BLACK,(x * elx+cx+20,y*ely+cy-Kory),font,String,True)

    elif Ele >= 1 and Ele <= 3:          # Gleis, Bahnsteig
        if String[0] == ':':             # Link            
            if Lp > 0:
                text(canvas,GRAY,(x * elx+cx+20+40,y*ely+cy-20),font14,String[1],True)
            elif Lp < 0:
                text(canvas,GRAY,(x * elx+cx+20-40,y*ely+cy-20),font14,String[1],True)
            else:
                text(canvas,GRAY,(x * elx+cx+20,y*ely+cy-Kory),font14,String[1],True)
        else:
            text(canvas,BLACK,(x * elx+cx+20,y*ely+cy-Kory),font,String,True)

    elif Ele != 0:
        #print('Nele,korx,kory:',Ele,Korx,Kory)
        cx = cx + Korx
        cy = cy + Kory
        ix = x*elx+cx
        iy = (y-1)*ely+cy
        text(canvas,BLACK,(ix,iy),font,String)

    return


def stric(x1,y1,x2,y2,col,lt,canvas):
    line(canvas,col,(x1,y1),(x2,y2),lt)
    return 0

def Shaspect(x,y,Styp,Asp,canvas):        #ShPicture    Sh ohne Hp

    ex = int(x * elx + offsx + int(elx/2) )
    ey = int(y * ely + offsy + int(ely/2) )

    HpAspect(x,y,Styp,'Sh0',canvas)       #CircleSig()

    if Styp == 30:
        px1 = 21;  py1 = 8           # px1 = 19, py1 = 7
        py2 = 9
    else:
        px1 = -19; py1 = -16;        # px1 = -20; py1 = -17;
        py2 = 9

    px3 = 17; py3 = 8                # Fahrstellungen noch angepassen!
    px4 = 15; py4 = 10
    px5 = 22; py5 = 16
    px6 = 23; py6 = 15

    corner = Styp & 0x03
    if (corner==1) or (corner==3):
        px3 = -px3; py3 = -py3
        px4 = -px4; py4 = -py4
        px5 = -px5; py5 = -py5
        px6 = -px6; py6 = -py6

    if (Asp == 'Sh0'):
        line(canvas,BLACK,(px1+ex,py1+ey),(px1+ex,py1+ey+py2),2)

    elif Asp == 'Sh1':
        polygon(canvas,BLACK,[(px3+ex,py3+ey),(px4+ex,py4+ey),
                              (px5+ex,py5+ey),(px6+ex,py6+ey)])

    return



def ShHaspect(x,y,Styp,Asp,canvas):     #ShHPicture() Sh am Hp-Signal

    ShHaspdel(x,y,Styp,canvas)

    if Styp == 26:               # Signal unten, nach rechts
        px1 = 8;   py1 = 9       # py1 = 7
        px2 = 2;   py2 = 8       # py2 = 9
    else:
        px1 = -10; py1 = -16     # Signal oben, nach links
        px2 = 2;   py2 = 9

    px3=6;  py3=9                # Fahrstellung noch nicht angepasst
    px4=5;  py4=10
    px5=13; py5=15
    px6=14; py6=14

    ex = int(x * elx + offsx + int(elx/2) )
    ey = int(y * ely + offsy + int(ely/2) )

    corner = Styp & 0x03
    if (corner==1) or (corner==3):

        px3 = -px3; py3 = -py3
        px4 = -px4; py4 = -py4
        px5 = -px5; py5 = -py5
        px6 = -px6; py6 = -py6

    if (Asp == 'Sh0'):
        rect(canvas,BLACK,[(int(px1+ex),int(py1+ey)),(int(px2),int(py2))])
    elif Asp == 'Sh1':
        polygon(canvas,BLACK,[(px3+ex,py3+ey),(px4+ex,py4+ey),
                              (px5+ex,py5+ey),(px6+ex,py6+ey)])
    return


def ShHaspdel(x,y,Styp,canvas):     #Begriff löschen (Aspect delete)
    px = 9
    py = 12
    cr = 4

    corner = Styp & 0x03

    if ((corner == 1) or (corner == 3)):
        px=-px; py=-py;

    #ex = int(x * elx + offs + elx/2 + px)
    #ey = int(y * ely + offs + ely/2 + py)
    ex = x * elx + offsx + elx/2 + px
    ey = y * ely + offsy + ely/2 + py

    #circle(canvas,WHITE,(ex,ey),cr)
    circle(canvas,WHITE,(int(ex),int(ey)),cr)
    return



def HpAspect(x,y,Styp,Term,canvas):      #CircleSig()  Hauptsignal

    if Term == 'Hp0':
        color = RED
    else:
        color = GREEN

    px = 19
    py = 12
    cr = 4

    if Styp == 30 or Styp == 31:          # Sh-Signal
        color = WHITE
        cr = 5
    if Styp == 30:
        px = 20

    corner = Styp & 0x03

    if ((corner == 1) or (corner == 3)):  # Signal oben (nach links)
        px=-px; py=-py;

    ex = int(x * elx + offsx + elx/2 + px)
    ey = int(y * ely + offsy + ely/2 + py)

    circle(canvas,color,(ex,ey),cr)

    return


def sigScreen(x,y,Styp,canvas):           # Hp Signalschirm
    ex = x * elx + offsx + int(elx/2)
    ey = y * ely + offsy + int(ely/2)

    px1=12;  py1=6
    px2=23;  py2=6
    px3=27;  py3=10
    px4=27;  py4=14
    px5=23;  py5=18
    px6=12;  py6=18

    corner = Styp & 0x03

    if ((corner == 1) or (corner == 3)):
        py1=-py1; py2=-py2; py3= -py3; py4=-py4; py5=-py5; py6=-py6
        px1=-px1; px2=-px2; px3= -px3; px4=-px4; px5=-px5; px6=-px6

    a1 = int(px1+ex); b1 = int(py1+ey)
    a2 = int(px2+ex); b2 = int(py2+ey)
    a3 = int(px3+ex); b3 = int(py3+ey)
    a4 = int(px4+ex); b4 = int(py4+ey)
    a5 = int(px5+ex); b5 = int(py5+ey)
    a6 = int(px6+ex); b6 = int(py6+ey)

    polygon(canvas,BLACK,[(a1,b1),(a2,b2),(a3,b3),(a4,b4),(a5,b5),(a6,b6)])
    HpAspect(x,y,Styp,'Hp0',canvas)

    return


def ShHscreen(x,y,Styp,canvas):             # Sh-Signal am Hp-Signal
    ex = x * elx + offsx + int(elx/2)
    ey = y * ely + offsy + int(ely/2)


    px1= 4;  py1= 7
    px2=10;  py2=10

    corner = Styp & 0x03

    if ((corner == 1) or (corner == 3)):
        #px1=-px1; #px2=-px2;
        #py1=-py1; #py2=-py2;
        px1=-13
        py1=-17

    rect(canvas,BLACK,[(round(px1+ex),round(py1+ey)),(round(px2),round(py2))])

    ShHaspect(x,y,Styp,'Sh0',canvas)

    return


def ShScreen(x,y,Styp,canvas):               # Sh-Signal alleinstehend
    ex = x * elx + offsx + int(elx/2)
    ey = y * ely + offsy + int(ely/2)

    if Styp == 30:               # Sh unten, nach rechts
        px1 = 15;  py1 = 7       # px1=14;  py1= 7
        px2 = 12;  py2 = 11      # px2=10;  py2= 11
    else:                        # Sh oben, nach links
        px1 = -24; py1 = -17;    # px1 = -24; py1 = -17;
        px2 =  12; py2 =  11     # px2 =  10; py2 = 11


    rect(canvas,BLACK,[(int(px1+ex),int(py1+ey)),(int(px2),int(py2))])
    Shaspect(x,y,Styp,'Sh0',canvas)

    return


def StandSig(x,y,Styp,canvas):
    ex = x * elx + offsx + int(elx/2)
    ey = y * ely + offsy + int(ely/2)

    if Styp == 26:      #Hp/Sh unten nach rechts
        px1 = -1; py1= 11
        px2 =  5; py2= 3

    elif Styp == 27:    #Hp/Sh oben nach links
        px2 = -4; py2 = -1
        px1 =  0; py1 = -11

    elif Styp == 28:    #Hp unten nach rechts
        px1 = 7;  py1= 11
        px2 = 5;  py2= 3

    elif Styp == 29:    #Hp oben nach links
        px1 = -12; py1 = -13
        px2 =   5; py2 =   3

    elif Styp == 30:    #Sh unten nach rechts
        px1 = 10;  py1= 10
        px2 =  6;  py2=  3

    elif Styp == 31:    #Sh oben nach links
        px1 = -12; py1 = -13
        px2 =   5; py2 =   3

    rect(canvas,BLACK,[((px1)+(ex), (py1)+(ey)), ((px2),(py2))])




def sigName(x,y,Name,Styp,canvas,font):
    korx = 0
    kory = 0

    Styp = Styp & 0x1F
    if Styp==26:
        korx=10; kory=26

    elif Styp==27:
        korx=35; kory=1

    elif (Styp==28) or (Styp==30):
        #korx=20; kory=25
        korx=15; kory=25

    elif (Styp==29) or (Styp==31):
        korx=30; kory=1

    cx = x * elx + korx+offsx
    cy = y * ely + kory+offsy

    text(canvas,BLACK,(cx,cy),font,Name)

    return
