# pyOpP6_0c.py Quelle pyOpP6_0b
# Lizenzbestimmungen:
# Autoren: Friedrich Bollow
# Lizenzvertrag: CC BY-NC-SA 4.0
# Kurzform: Namensnennung - Nicht-kommerziell - Weitergabe unter gleichen Bedingungen 4.0 International
# Details: creativecommons.org/licenses/by-nc-sa/4.0/legalcode.de

import drawOpra25 as Draw
from VariablesEd11 import *
import RDstr41 as RDstr
import RouteZT20 as route     
import os
import sys
import platform
import time
import types

import serial

import threading
import queue
from queue import Queue

import ntpath          #Dateiname csv ohne Pfad

from pathlib import Path

import tkinter as tk
from tkinter import *
from tkinter import filedialog # extra import
from tkinter import messagebox
from tkinter.font import Font


#---------------------------------------------

fname   = ""
zname   = ""

root    = None
canvas  = None

font    = None
fontm   = None

ChgFlag = False

pfad     = None
lastpath = None   # im SizeFile

SizeFile   = 'Panelsize.txt'
LocIDFile  = 'LocoID.txt'
LocFVFile  = 'LocoFV.txt'

Ttfile     = ""
Ttloopcnt  = 1

ZLfile     = ""

DKWside    = 'a/b'
Signal_ZR  = 'Zugf'
SignalDep  = False

GreenX     = 0   # RouteClass Kachel Grün
GreenY     = 0
RouteClass = int(0)

Green1     = [0,0] #Route release
RelbyTrain = False #False: Zug und Bedienung, True: Train only

GrauFeld   = 2   # Kachel Option, Optionswahl

Gray1      = [0,0] # Tt on/off
Gray2      = [0,0] # Tt hold
Gray3      = [0,0] # ZL Tile
ZLtile     = False # Gray3
ZLactive   = False # ZL off/on

Red1       = [0,0] # Sgnal Departure
Deptile    = False # Red1

TttileState= 1     # Stop 
Tttile     = False # Gray2
TCtile     = False # Gray1
Ttactive   = False # Tt off/on

fplfenst   = None  #Fahrplaninfo fenster

GelbX      = 0   # Message Kachel gelb (SerIF)
GelbY      = 0
SerTile    = False

OkerX      = 0   # Message Kachel oker (Arduino)
OkerY      = 0
ArdTile    = False
RCLtile    = False

sinState   = False
#SerialIO   = 0

SimStatecnt= 0


ser        = None   #  "

lastRm     = 0      #letzte Rückmeldebits

ucnt       = 0

update_id  = None

XBusok     = False

Adrconv    = 0      #0,-4,+4, Lenz <-> Roco

mstr       = ''
cmd        = ''

TimerA     = 0     #3580+3600 = 1:59:42
timer_id   = None

tda        = 8     # Fstr. mit Startsignal, Tt Korrektur, defaults
tdb        = 8     # Richtwechsel und Fstr.

WendeSkip  = False #Bei Wendefahrt keine Prüfung Fstr Hp1

Bskip      = False #Kmd. zeile Param 1: dann True

#---------------------------------------------

#menu = ["   Load    ","   Save  "," ClrScreen"," printCSV ","   size   ","  move  "]
menu  = ["   Load    ","   ----  "," Load Tt  ","  Load ZL ","new Ser.IF","   tbd  "]
menuoffsets = list()

DIMsl  = 10 #Weichennamen u.a. Texte
DIMslS =  6 #Signalnamen
DIMslF = 50 #Fahrwege
DIMslT = 15 #Infotext

Stp = [[types.SimpleNamespace() for x in range(dim_x)] for y in range(dim_y)]

copmov    = 0    # 0 move, 1 clear, 2 copy
MoveState = 0    # 3 Punkte für Blockmove
px1       = 0
py1       = 0
px2       = 0
py2       = 0

Rm        = []   # Tabelle der Rückmelder, Index ist RM-Nummer, ArrayInhalt ist x,y der
                 # Position auf dem Bildschirm, Tabelle durch parserRmel() anlegen
                 # 0: x, 1:y, 2: belegt, 3: Fstr.

for n in range(33):
    Rm.append((int(0), int(0), False))
                 
for n in range(33):
    Rm[n] = list(Rm[n])
    
        #    m s z fw fs
Ttab     = [[0,0,0,'','']]   # Tabelle Timetable (Fahrplan)
Ttindex  = 0
Tticnt   = 0

#LokStart Queue
qLokHp1 = Queue(maxsize=10)
#qLokHp1.put('Tarzan')
#qLokHp1.put('Jane')

LokHp1delay = 0

#Zuglenkqueue
ZLqueue = Queue(maxsize=10)
ZLqueue.put('Bunny')
print(ZLqueue.get())

#Zuglenktabelle
ZLtab  = []      #[[]] not required
ZLicnt = 0

LocotabF  = []   #nur für Horn und Licht
LocotabV  = []   #Fahrstufen Hp1, V/2


              
#-----------------------------------------------------------
# goto START


#-----------------------------------------------------------

# W-Weichen
#    'x'    int
#    'y'    int
#    'N'    wchar * DIMsl
#    'DA'   int
#    'U'    int
#    'Lage' int

# S-Signale
#    'x'    int
#    'y'    int
#    'N'    wchar * DIMslS
#    'ST'   int
#    'DA'   int
#    'Rm'   int
#
# i_Melder
#    'i'    int
#    'x'    int
#    'y'    int
#    'T'    int
#
# b_Fweg
#    'b'    int
#    'x'    int
#    'y'    int
#    'N'    wchar * DIMsl
#    'Fw'   wchar * DIMslF
#
# K_Decoder
#    'x'    int
#    'y'    int
#    'N'    wchar * DIMsl
#    'T'    int
#    'DA'   int
#
# t_Infotext
#    'x'    int
#    'y'    int
#    'N'    wchar * DIMslT
#    'Rm'   int
#

def Rm_refresh():
    for k in range(0,16):          #1-16 (array 0-15)         
        if Rm[k+1][2] == True:
            x = Rm[k+1][0]
            y = Rm[k+1][1]
            Draw.trackl(x,y,RED,canvas)

def drawGrid():
    canvas.delete("all")
    Draw.resetCanvasObjects()      #ergänzt Claus

    for i in range(offsx,sy,ely):  # linie horizontal
        #print("Number Y i",int(i/ely),int(i))
        Draw.line(canvas,BLACK,(int(offsx),int(i+offsy-14)),(int(sx-offsx),int(i+offsy-14))) # linie horizontal
                                   #      x1        y1                  x2          y2
    for i in range(offsx,sx,elx):  # linie vertikal
        Draw.line(canvas,BLACK,(i,offsy),(i,(ElanzY+1)*ely+5)) # linie vertikal

    for i in range(ElanzX):        # text horizontal
        text = str(i)
        x = i*elx+offsx+int((elx-Draw.font_text_extent(font, text)[0])/2)
        Draw.text(canvas,BLACK,(x, int(offsy/2 +10)),font,text)

    for i in range(ElanzY):        # text vertikal
        text = str(i)
        y = i*ely+offsy+int((ely-Draw.font_text_extent(font, text)[1])/2)
        Draw.text(canvas,BLACK,(2, y),font,text)
    
    st = ""
    menuoffsets.clear()
    menuoffsets.append(offsx)
    for i in range(len(menu)):
        st = st + menu[i]
        textpixlen = Draw.font_text_extent(curfont, st)[0]
        menuoffsets.append(menuoffsets[0]+textpixlen)
        if i<len(menu)-1:
            st = st + " |"
    Draw.rect(canvas,WHITE,[(menuoffsets[0],8),(menuoffsets[len(menu)]-menuoffsets[0],20)])
    Draw.text(canvas,BLACK,(menuoffsets[0], 10),curfont,st)

    mmcUpdateLabel(canvas)
    mmcResetState(canvas)

    setChangeFlag(0)

    
    showFilename(canvas, fname)

    return


def updateDrawings(canvas):
    # zu zeichnende Elementflächen links und rechts ausweiten
    # (da Teile alter Texte in Nachbarfelder liegen könnten)
    for y in range(ElanzY):
        for x in range(1, ElanzX):
            Stp[y][x-1].Redraw |= Stp[y][x].Redraw
        for x in range(ElanzX-1, 0, -1):
            Stp[y][x].Redraw |= Stp[y][x-1].Redraw
    # alle Elemente außer Texte zeichnen (sind immer innerhalb eines Feldes)
    for y in range(ElanzY):
        for x in range(ElanzX):
            if Stp[y][x].Redraw:
                Draw.rect(canvas,TABLE,[(x*elx+offsx+1,y*ely+offsy+1),(elx-1,ely-1)])
                e = Stp[y][x]
                if e.Ele != 0:                    
                    if e.Ele in [16,17,18,19] and e.Lage > 1:
                        #print('>>>>>>>>>>> .Lage:',e.Lage)
                        Draw.EleDraw(x, y, e.Ele, e.Lage,canvas)
                    else:
                        Draw.EleDraw(x, y, e.Ele, 0,canvas)
                if e.Sel == 'S':
                    if e.N[0] != '*':   #Stumpfgleis
                        Draw.EleDraw(x,y,e.ST,0,canvas)
                if e.Sel == 'i':
                    color = ''
                    if e.T == 1:
                        color = YELLOW
                    if e.T == 2:
                        color = OKER
                    if e.T == 3:
                        color = LBLUE
                    if e.T == 4:
                        color = GREEN
                    if e.T == 5:
                        color = RED
                    if e.T == 6:
                        color = LGRAY
                    Draw.rect(canvas,color,[(x*elx+offsx+1,y*ely+offsy+1),(60,40)])
                    
                    if e.T == 1:
                        Draw.textInfo(GelbX,GelbY,0,'SerialIF',1,font,font14,canvas)
                        
                    elif e.T == 3:
                        Draw.text(canvas,BLACK,(x*elx+offsx+elx/2,y*ely+offsy+ely/2),font14,DKWside,True)
                        
                    elif e.T == 5:      #rot Signal
                        if e.Mul == 0:
                            Draw.text(canvas,BLACK,(x*elx+offsx+elx/2,y*ely+offsy+ely/2),font14,Signal_ZR,True)
                        elif e.Mul == 1:
                            Draw.textInfo(x,y,0,'Departure',1,font,font14,canvas)
                            Draw.text(canvas,BLACK,(x*elx+offsx+elx/2,y*ely+offsy+ely/2),font,'Off',True)
                            
                    elif e.T == 4:      #grün Fstr
                        if e.Mul == 0:
                            Draw.textInfo(GreenX,GreenY,0,'Route CL',1,font,font14,canvas)
                            Draw.text(canvas,BLACK,(x*elx+offsx+elx/2,y*ely+offsy+5+ely/2),font14,RouteClass,True)
                        elif e.Mul == 1:
                            Draw.textInfo(Green1[0],Green1[1],0,'R.release',1,font,font14,canvas)
                            Draw.textInfo(Green1[0],Green1[1],0,'Operator',0,font,font14,canvas)
                            Draw.textInfo(Green1[0],Green1[1],0,'by Train',2,font,font14,canvas)
                            
                    elif e.T == 6:      #grau
                        if e.Mul == 0:
                            Draw.textInfo(x,y,0,'Option',1,font,font14,canvas)
                            DrawOption(x, y, GrauFeld)
                            
                        elif e.Mul == 3:
                            Draw.textInfo(x,y,0,'ZL',1,font,font14,canvas)
                            Draw.text(canvas,BLACK,(x*elx+offsx+elx/2,y*ely+offsy+ely/2),font,'Off',True)
                        elif e.Mul == 1:
                            if TCtile and Ttfile != "":
                                fname = ntpath.basename(Ttfile) 	#aus Maus e.Mul ==1:
                                Draw.rect(canvas,LGRAY,[(Gray1[0]*elx+offsx+1,Gray1[1]*ely+offsy+27),(elx-1,14)])
                                Draw.textInfo(Gray1[0],Gray1[1],0,fname[0:9],2,font,font14,canvas)
                        
                if e.Sel == 'b':
                    ex = int(x * elx + offsx + elx/2)
                    ey = int(y * ely + offsy + ely/2)
                    if e.Ele == 0:                        
                        Draw.circle(canvas,YELLOW,(ex,ey),6)
                    else:
                        Draw.circle(canvas,YELLOW,(ex-15,ey-13),6)                        
                        
                if e.Sel == 'K':
                    ex = int(x * elx + offsx + elx/2)
                    ey = int(y * ely + offsy + ely/2)
                    Draw.circle(canvas,DGRAY,(ex,ey),8)
                    Draw.circle(canvas,WHITE,(ex,ey),3)
                if hasattr(e, 'Rm') and e.Rm != 0:
                    ex = int(x * elx + offsx + elx/2)
                    ey = int(y * ely + offsy + ely/2)
                    Draw.circle(canvas,GRAY,(ex,ey),6)
    # zu zeichnende Elementflächen nochmals ausweiten
    # (da neu gezeichnete Felder Text aus Nachbarfeldern enthalten könnten)
    for y in range(ElanzY):
        for x in range(1, ElanzX):
            Stp[y][x-1].Redraw |= Stp[y][x].Redraw
        for x in range(ElanzX-1, 0, -1):
            Stp[y][x].Redraw |= Stp[y][x-1].Redraw
    # Texte zum Schluss zeichnen (da bis zu drei Felder breit)
    for y in range(ElanzY):
        for x in range(ElanzX):
            if Stp[y][x].Redraw:
                e = Stp[y][x]
                e.Redraw = False
                if e.Sel == 'W':                    
                    Draw.textInfo(x,y,0,e.N,e.Ele,font,font14,canvas)
                if e.Sel == 'S':
                    Draw.sigName(x,y,e.N,e.ST,canvas,font)
                if e.Sel == 't':
                    c = Stp[y][x+1]
                    d = Stp[y][x-1]
                    #print('links rechts',d.Ele,c.Ele)
                    if c.Ele == 0:    #Für Link-Position
                        Lp = 1
                    elif d.Ele == 0:                    
                        Lp = -1
                    else:
                        Lp = 0
                    Draw.textInfo(x,y,Lp,e.N,e.Ele,font,font14,canvas)
                    
                if e.Sel == 'b':
                    if e.Ele == 0:   
                        Draw.textButt(x,y,e.N,font,canvas)
                    else:
                        Draw.textButtEle(x,y,e.N,font,canvas)
                        
                if e.Sel == 'K':
                    Draw.textButt(x,y,e.N,font,canvas)


def showFilename(canvas, name):
    OfsX = menuoffsets[len(menuoffsets)-1]+40 # hinter dem roten Punkt
    OfsY = 8
    Draw.rect(canvas,WHITE,[(OfsX,OfsY),(2*elx, 20)])
    Draw.text(canvas,BLACK,(OfsX+2,OfsY+3),font,name)


def mmcUpdateLabel(canvas):
    #Tastentext copy/clear/move anzeigen
    st = '  '+ ("tbd", "clear", "copy")[copmov] + '  ';
    Color = BLACK
    if MoveState != 0:
        st = '<abort>'
        Color = RED
    if Platform == "Windows":
        curfont = fontm #Windows
    else:
        curfont = font  #Raspberry
    x0 = menuoffsets[6]-Draw.font_text_extent(curfont, menu[5])[0]
    x1 = menuoffsets[6]
    y0 = 8
    Draw.rect(canvas,WHITE, [(x0, y0), (x1-x0, 20)])
    Draw.text(canvas,Color, (x0, y0+3), curfont, st)


def mmcResetState(canvas):
    #Abbruch copy/clear/move
    global MoveState
    if MoveState != 0:
        Stp[py1][px1].Redraw = True
        Stp[py2][px2].Redraw = True
        updateDrawings(canvas)
        MoveState = 0
        mmcUpdateLabel(canvas)


def updateSerialState(canvas):
    global sinState
    global XBusok
    ex = int(GelbX * elx + offsx + elx/2)
    ey = int(GelbY * ely + offsy + ely/2 +7)    
    
    if SerialIO.GetState():
        Draw.circle(canvas,WHITE,(ex,ey),8)
        sinState = True
        
    else:
        Draw.circle(canvas,DGRAY,(ex,ey),8)
        sinState = False

    SimuState(sinState,XBusok)
    


def SimuState(sinState,XBusok):
    global SimStatecnt
    txp = 460
    if sinState and XBusok:
        Draw.rect(canvas,TABLE,[(txp,8),(60,20)])
        SimStatecnt += 1
    else:
        Draw.rect(canvas,RED,[(txp,8),(60,20)])
        st = 'Simulation'
        Draw.text(canvas,WHITE,(txp,8),font,st)

        if SimStatecnt > 0:
            if Ttactive: Ttresume()      #Timetable halt
        


def setChangeFlag(NewState):
    global ChgFlag
    if ChgFlag != NewState:
        ChgFlag = NewState
        cx = menuoffsets[len(menuoffsets)-1]+20 # hinter letztem Menueintrag
        if NewState != 0:
            Draw.circle(canvas,RED,(cx,16),5)
        else:
            Draw.circle(canvas,TABLE,(cx,16),5)


def clearEle(x, y):
    Stp[y][x] = types.SimpleNamespace()
    e = Stp[y][x]
    e.Ele = 0
    e.Sel = ''
    e.Redraw = True
    # no updateDrawings()!
    

def clearAll():
    drawGrid()

    for y in range(dim_y):
        for x in range(dim_x):
            clearEle(x, y)
            
    Rm_refresh()
    

def DrawOption(x, y, opt):
    if opt == 1:                              
        Draw.textInfo(x,y,0,'Rfwend',0,font,font14,canvas)
    elif opt == 2:
        Draw.textInfo(x,y,0,'LokStopL',0,font,font14,canvas)
    elif opt == 3:
        Draw.textInfo(x,y,0,'LokStopS',0,font,font14,canvas)
          
#--------------------------------------------------------

class SerialIO_Class:
    _root = None
    _port = None
    _serial = None
    _event = None
    _queue = None
    _doTerminate = False
    _doInit = True
    _thread = None

    def __init__(self, Root, Port):
        self._root = Root;
        self._port = Port;
        self._event = threading.Event()
        self._queue = queue.Queue()
        self.__thread_start()

    def Reset(self):
        self.Terminate()
        self.__thread_start()

    def Terminate(self):
        self._doTerminate = True
        self._event.set()
        try:
            self._serial.close()
        except:
            pass
        self._thread.join()

    def GetPort(self):
        return self._port; # /dev/ttyUSB0

    def SetPort(self, Port):
        if Port!=self._port:
            self.Terminate()
            self._port = Port
            self.__thread_start()

    def GetState(self):
        return not self._doInit; # SerialConnected -> True

    def GetReceived(self):
        Item = ""
        while not self._queue.empty():
            Item = Item + self._queue.get().decode("cp1252", "ignore")
        return Item;

    def __thread_start(self):
        self._doTerminate = False
        self._event.clear()
        self._thread = threading.Thread(target=self.__thread_function, args=(self, ))
        self._thread.start()

    def __thread_function(self, cdvcx):
        self._doInit = True
        while not self._doTerminate:

            if self._doInit:
                try:
                    if self._serial is None:
                        self._serial.close()
                    self._serial = None
                except:
                    pass
                try:
                    self._serial = serial.Serial(self._port, 9600) # no timeout
                    self._serial.reset_input_buffer()
                    self._doInit = False
                    time.sleep(1)
                    enc = str.encode('Rasp start'+'\n')
                    self._serial.write(enc)
                    
                    if not self._doTerminate:
                        self._root.event_generate("<<SerialIO_StateEvent>>")
                except:
                    if not self._doTerminate:
                        self._root.event_generate("<<SerialIO_StateEvent>>")
                    self._event.wait(timeout=2)
            else:
                try:
                    # receivedData = self._serial.read() #
                    receivedData = self._serial.readline() #
                    self._queue.put(receivedData)
                    if not self._doTerminate:
                        self._root.event_generate("<<SerialIO_ReceivedEvent>>")
                except:
                    self._doInit = True

    def Wswitch(self, Adr, swp):
        global Adrconv
        if DebugFs: print('Aconv,Adr,swp',Adrconv,Adr,swp)
        
        #--------------------
        if Adr < 0:
            vz = -1
        else:
            vz = 1
        absAdr = abs(int(Adr))
        #--------------------
                     
        if int(Adrconv) >= 0:
            Adr = absAdr + int(Adrconv)            
        else:
            if absAdr < 5:
                Adr = 2044 + absAdr
                if DebugFs: print('absAdr',absAdr)
            else:
                Adr = absAdr + int(Adrconv)
        Adr = Adr * vz
            
        if DebugFs: print('Adrcor.',Adr)
        #--------------------
        if swp != 0:
            Adr = Adr * (-1)
        enc = str.encode('switch '+str(Adr)+'\n')
        try:
            self._serial.write(enc)
            enc = str.encode(str(Adr)+'\n')
            self._serial.write(enc)
        except:
            if not self._doInit:
                self.Reset()

#--------------------------------------------------------                

    def SendSigStop(self, RmNr, Lok, Graufeld):
        if Graufeld == 3:
            enc = str.encode('b'+str(RmNr)+','+str(Lok)+','+'\n') #Stop sofort
        else:
            enc = str.encode('B'+str(RmNr)+','+str(Lok)+','+'\n') #Stop mit Auslauf
        try:
            self._serial.write(enc)
        except:
            if not self._doInit:
                self.Reset()
                

    def SendStopvoid(self, RmNr, Lok):                        # Stop löschen
        enc = str.encode('V'+str(RmNr)+','+str(Lok)+','+'\n')
        try:
            self._serial.write(enc)
        except:
            if not self._doInit:
                self.Reset()
        



    def SendLokStart(self, RmNr, Lok, Speed):
        enc = str.encode('L'+str(RmNr)+','+str(Lok)+','+str(Speed)+','+'\n') #Start
        print('str2Ard:',enc)
        try:
            self._serial.write(enc)
        except:
            if not self._doInit:
                self.Reset()


    def SendLokBypass(self, RmNr, Lok, Speed):
        enc = str.encode('G'+str(RmNr)+','+str(Lok)+','+str(Speed)+','+'\n') #Bypass (RmNr=Dummy)
        print('str2Ard:',enc)
        try:
            self._serial.write(enc)
        except:
            if not self._doInit:
                self.Reset()
                

    
    def SendLokStop(self, RmNr, Lok):
        enc = str.encode('l'+str(RmNr)+','+str(Lok)+','+'\n') #Stop
        try:
            self._serial.write(enc)            
        except:
            if not self._doInit:
                self.Reset()        


    def SendLokDir(self, RmNr, Lok):
        enc = str.encode('D'+str(RmNr)+','+str(Lok)+','+'\n') #Direction
        try:
            self._serial.write(enc)
        except:
            if not self._doInit:
                self.Reset()
                

    def SendLokFunc(self, RmNr, Lok, Lfunc):
        enc = str.encode('F'+str(RmNr)+','+str(Lok)+','+str(Lfunc)+','+'\n') #Func
        try:
            self._serial.write(enc)
        except:
            if not self._doInit:
                self.Reset()


    def SendLokHorn(self, RmNr, Lok, Lfunc):
        enc = str.encode('f'+str(RmNr)+','+str(Lok)+','+str(Lfunc)+','+'\n') #Horn. Toggle        
        try:
            self._serial.write(enc)
        except:
            if not self._doInit:
                self.Reset()

    def SendLokSpeed(self, RmNr, Speed):
        enc = str.encode('S'+str(RmNr)+','+str(Speed)+','+'\n') #Speed
        try:
            self._serial.write(enc)
        except:
            if not self._doInit:
                self.Reset()    
            
                
#--------------------------------------------------------

def filltime(fillt, cnt):
    global tda, tdb		# Zeit rückrechnen in s
    global Ttab
    
    mint = int(Ttab[cnt][0])            # int(!)
    sect = int(Ttab[cnt][1]) & 0xFFFE   # nur gerade sec. Werte

    secs = mint * 60 + sect             # Timetable 1, Basiswert
    if DebugTf: print('Tt = 1 secs:',secs)
    fi = len(fillt) -1
    ti = 0
    
    if DebugTf: print('filltime LZiff:',Ttab[cnt])
    if DebugTf: print('fillt:',fillt)

    while fi >= 0:
        if int(fillt[fi]) >= 0:
            if DebugTf: print('korrektur für:',Ttab[fillt[fi]])            
            if ti == 0:
                mdelta = tda
            else:
                mdelta = tda + ti * tdb
            newsecs = secs - mdelta 
            if DebugTf: print('newsecs:',newsecs)
            
            h, m = divmod(newsecs, 3600)
            m, s = divmod(m, 60)
            m = str(m)        
            s = str(s)
            s = s.zfill(2)
            if DebugTf: print('zeit fill:',m,s)

            Ttab[fillt[fi]][0] = m
            Ttab[fillt[fi]][1] = s
            ti += 1
            if DebugTf: print('new line >>>>>>>>: ', Ttab[fillt[fi]])            
        
        fi -= 1
        
#--------------------------------------------------------------

def retypeVinLtab():
    for i in range(len(LocotabV)):       
        LocotabV[i][1] = 0


def setVist(Lok, Speed):
    global LocotabV
    for i in range(len(LocotabV)):
        if int(Lok) == int(LocotabV[i][0]):
            LocotabV[i][1] = Speed
            break
    

def getVist(Lok):
    global LocotabV
    Vist = -1
    for i in range(len(LocotabV)):
        if int(Lok) == int(LocotabV[i][0]):
            Vist = LocotabV[i][1] 
            break
    
    return Vist
        

def Vvalue(Lok, Vindex):
    global LocotabV
    if Vindex >= 2 and Vindex <= 5:
        #index            2  3  4  5
        speedList = (0,0,45,55,55,65)
        speedL    = speedList[Vindex]   #default

        for i in range(len(LocotabV)):
            if str(Lok) == LocotabV[i][0]:
                speedL = LocotabV[i][Vindex]
                print('Lok',LocotabV[i][0],'speed',speedL)
    else:
        speedL = 44

    return speedL


def Fvalue(Lok, Findex):  #index: 0= Licht front, 1= Licht schluss, 2= Horn
    global LocotabF
    if Findex  <= 2:        
        func = Findex          # Fall: Lok not in List
        if func == 2: func = 4
        for i in range(len(LocotabF)):
            if Lok == LocotabF[i][0]:
                if DebugFV: print('LoktacbF:',LocotabF[i])
                func = LocotabF[i][Findex+2]
                if DebugFV: print('Lok',LocotabF[i][0],'Funktion',func)
    else:
        print("Fvalue Index ungültig")
        func = 0
        
    return func

#----------------------------------------------------------------------

def checkLstr(st,cntcmp):
    rval = True
    cnt = st.count(',')    
    if cnt != cntcmp:        
        rval = False
    else:    
        if st[-1] != ',':            
            rval = False    
    return rval   
     

def rdLocoFV():
    global LocotabF
    global LocotabV

    LocotabF.clear()           #keine neue tab
    LocotabV.clear() 
       
    print('try to open:',LocFVFile)   
    
    try:
        fv = open(LocFVFile, 'r')
                
        while True:
            dat = fv.readline()            
            if not dat:
                fv.close()
                print('closed:',LocFVFile)
                break
            dat = dat.strip('\n')
            
            if DebugFV: print(dat)
                           
            v_split = dat.split(',')
            
            if len(dat.strip()) == 0 or v_split[0][0] == '\t':
                pass
            else:             
                if v_split[1] == 'F':
                    if not checkLstr(dat,5):
                        print('Error:',dat)
                        fv.close()
                        print('closed:',LocFVFile)
                        break
                    LocotabF.append(v_split)
                    
                elif v_split[1] == 'V':
                    if not checkLstr(dat,6):
                        print('Error:',dat)
                        fv.close()
                        print('closed:',LocFVFile)
                        break
                    LocotabV.append(v_split)

                else:                   #weder F noch V
                    print('Error: F,V?',dat)                    
                    
    except:
        print("no LocoFV file")

    if DebugFV:
        for i in range(len(LocotabF)): print(LocotabF[i])
    
    if DebugFV:
        for i in range(len(LocotabV)): print(LocotabV[i])

#---------------------------------------------------

def checkZLline(st):
    rval = True
    cnt = st.count(',')
    if cnt < 2 or cnt > 3:
        rval = False
        
    if st[-1] == ',':
        rval = False
    return rval
        

def RdZLdat(ZLfile):    
    global ZLtab
          
    ZLtab.clear()           #keine neue ZLab   
       
    print('try to open:',ZLfile)
    cnt = 0
    
    try:
        fz = open(ZLfile, 'r')
                
        while True:
            dat = fz.readline()            
            if not dat:
                fz.close()
                print('closed:',ZLfile)
                break
            dat = dat.strip('\n')            
                       
            if len(dat.strip()) == 0 or dat[0] == '\t' or dat[0] == ' ':
                pass
            else:                
                if not checkZLline(dat):
                    print('Error:',dat,' line ',cnt)    
                    fz.close()
                    print('closed:',ZLfile)
                    break
                
                if DebugZL: print(dat)
               
                z_split = dat.split(',')
                if type(z_split[0]) == str and len(z_split[0]) > 0:
                    if z_split[0][0] == '\t':
                        pass
                    else:
                        if z_split[0][0] == ' ':
                            print('Error Blank:',z_split)
                        else:
                            ZLtab.append(z_split)                       
                            cnt += 1
        
    except:
        print("no ZL file")

    if DebugZL:
        for i in range(cnt):
            print(ZLtab[i],'len:',len(ZLtab[i]))

    showFpl(ZLfile)        
    
    return cnt
#------------------------------------------------

def checkTtLine(st):
    rval = True

    v_sp = st.split(';')
    cnt = st.count(';')
    if v_sp[0] == 'Td':
        if cnt != 3:
            rval = False
            return rval
        else:
            return rval
    else:        
        if cnt  != 5:        
            rval = False        
        else:    
            for j in range(0, 3):        
                       
                if v_sp[j].isdigit():
                    pass
                else:
                    rval = False
        return rval
    

def RdTtdat(Ttfile):    
    global Ttab
    global Ttindex
    global Tticnt
    global tda
    global tdb    

    fillt = [-1,-1,-1,-1]
    fti   = 0
   
    Ttab.clear()           #keine neue Ttab
    Ttindex = 0
    
    print('try to open:',Ttfile)
    cnt = 0
    
    try:
        fz = open(Ttfile, 'r')
                
        while True:
            dat = fz.readline()
            if not dat:
                fz.close()
                print('closed:',Ttfile)
                break

            
            if len(dat.strip()) == 0 or dat[0] == '\t' or dat[0] == ' ':                
                t_split = dat.strip()
                t_split = t_split.split(';')             
                             
                if t_split[0] == 'Td':
                    print('t_split[0]',t_split[0])
                    ka = int(t_split[1])
                    kb = int(t_split[2])
                    print('check ka,kb:',ka,kb)
                    if 4 <= ka <= 30 and 4 <= kb <= 30:
                        print('ka,kb ok')
                        tda = ka
                        tdb = kb
                    else:
                        print('ka,kb nicht ok, defaults')
            else:
                #print('Tt line:', dat,end="")
                if not checkTtLine(dat):
                    print('Error:',dat,' line ',cnt)
                    fz.close()
                    print('closed:',Ttfile)
                    cnt = -1
                    break
                    
                if DebugTf: print(dat,end="")
                z_split = dat.split(';')                              
                                
                if z_split[0].isnumeric():                    
                    Ttab.append(z_split)
                    
                    if int(z_split[0])==0 and int(z_split[1])==0:  #Zeiten nachtragen                 
                        #print('index 0,1,cnt:',cnt)
                        fillt[fti] = cnt
                        fti += 1
                    if int(z_split[2])==1:                        #wenn Lenkziffer 1                     
                        if int(fillt[0]) >= 0:
                            filltime(fillt,cnt)
                        fillt = [-1]*len(fillt)
                        fti   = 0

                    cnt += 1
                
        print("num.items:", cnt)
        Tticnt += 1
        print()
        if DebugTf: Ttprint(cnt)        
        if cnt > 0:
            if checkFpl():
                return -1
            else:
                print('time check ok')
            TtFplfile(Ttfile)
        
    except:
        print("no Tt file")        
    
    return cnt

#----------------------------------------------------------------
def checkFpl():
    global Ttab
    fail = False
    for k in range(len(Ttab)-1):        
        secs = int(str(Ttab[k][0])) * 60 + int(str(Ttab[k][1]))
        secsn= int(str(Ttab[k+1][0])) * 60 + int(str(Ttab[k+1][1]))
        tdiff = secsn - secs
        if tdiff <= 0:
            print('Fehler Zeitabstand:' ,tdiff, 'at ',k+1, Ttab[k+1])
            fail = True
    return fail

#----------------------------------------------------------------

def TtFplfile(Ttpath):
    global Ttab
    print()    
    dir_path = os.path.dirname(Ttpath)    
    Ttfname = ntpath.basename(Ttpath)    
    FnameFp = "Fpl_" + Ttfname    
    NewFpl = Path(dir_path) / FnameFp     
    NewFpl = NewFpl.with_suffix(".txt")
    print("Fullname:",NewFpl)
    print("len Ttab:",len(Ttab))
    
    try:
        fh = open(NewFpl,'w')
        Fplname = Path(NewFpl).name
        fh.writelines('File:' + Fplname + '\n')                            
        
        for k in range(len(Ttab)):
            scnt = '%2d' %(k)
            if Ttab[k][2] == '1':                 
                sline = scnt + '  ' + Ttab[k][0] + ':' + Ttab[k][1] + ' ' + Ttab[k][2]+ ' ' \
                                   + Ttab[k][3] + ' ' + Ttab[k][4] + '\n'
                fh.writelines(sline)
            else:                
                sline = scnt + '  ' + "     " + Ttab[k][0] + ':' + Ttab[k][1] + ' ' \
                          + Ttab[k][2] + ' ' + Ttab[k][3] + ' ' + Ttab[k][4] + '\n'
                fh.writelines(sline)
            
        fh.writelines("--" + '\n')
        print(NewFpl,'file saved')
        fh.close()
      
        showFpl(NewFpl)

    except:
        print('Fpl-file not writeable')



def showFpl(NewFpl):
    global fplfenst 
    
    pre = Path(NewFpl).name

    ftext  = 'Textanzeige'  
    if pre[0] == 'F':
        ftext = 'Fahrplan'
    elif pre[0] == 'Z':
        ftext = 'Zuglenkung'
    

    # Vorheriges Fenster schließen, falls noch offen
    if fplfenst is not None and fplfenst.winfo_exists():
        fplfenst.destroy()    
    
    def open_Fplfile():
        file_path = NewFpl
        if file_path:
            with open(file_path, "r", encoding="utf-8") as file:
                content = file.read()
            text_widget.config(state='normal')  # Temporär entsperren zum Einfügen
            text_widget.delete("1.0", tk.END)
            text_widget.insert(tk.END, content)
            text_widget.config(state='disabled')  # Danach wieder sperren

    fplfenst = tk.Toplevel(root)
    fplfenst.title(ftext)

    text_widget = tk.Text(fplfenst, wrap='word', state='disabled', height=40, width=40)
    text_widget.pack(padx=10, pady=10, fill='both', expand=True)

    open_Fplfile()

  
#---------------------------------------------------

def Ttprint(cnt):
    global Ttab
    print('File:',Ttfile)
    for k in range(cnt):
        if Ttab[k][2] != '1':
            print('     ',end= "")
        print(Ttab[k][0],':',Ttab[k][1],sep="",end="")
        print(' ',Ttab[k][2],Ttab[k][3],Ttab[k][4])    
        
             

def readSize():
    global lastpath
    global Adrconv
    global RouteClass
    global RCLtile
    global Ttfile
    
    io = False
    serport = 'COM4'                # default

    try:
        fh = open(SizeFile, 'r')
        panelsiz = fh.readline()

        a_split = panelsiz.split(';')

        if a_split[0] != 'Ps':
            print("not a size file")
        else:
            ax = int(a_split[1])
            ay = int(a_split[2])

            if (ax >= 8 and ax <= 31) and (ay >= 7 and ay <= 24):
                io = True
                
        secline  = fh.readline()
        b_split  = secline.split(';')
        if b_split[0] != 'Fp':
            print("no last file info")
        else:
            lastpath = b_split[1]        
            print('lastpath:',lastpath)

        thirdline  = fh.readline()
        c_split  = thirdline.split(';')
        if c_split[0] != 'Si':
            print("no comport info")
        else:
            serport = c_split[1]        
            print('comPort:',serport)

        fourthline = fh.readline()
        c_split  = fourthline.split(';')
        if c_split[0] != 'Ac':
            Adrconv = 0
            print("no Adr. conv.")
        else:
            Adrconv = c_split[1]        
            print('Adr. conv:',Adrconv)

        fifthline = fh.readline()
        c_split  = fifthline.split(';')
        if c_split[0] != 'Rc':
            RouteClass = 0
            print("no RouteClass.")
        else:
            RouteClass = int(c_split[1])
            print('Debug1 RouteClass read:',RouteClass)
            if RouteClass < 0 or RouteClass > 2:
                RouteClass = 0
            print('Debug2 RouteClass read,tile:',RouteClass,RCLtile)

        sixthline = fh.readline()
        c_split  = sixthline.split(';')
        if c_split[0] != 'Tt':
            print("no Tt-file.")
        else:
            Ttfile = c_split[1]
            print('Tt-file:',Ttfile)
            

        fh.close()

    except:
        print("no size file")
        ax = 17
        ay = 16

    return io,ax,ay,serport,Adrconv


def writeSize(ax,ay,pfad,Adrconv,RouteClass):
    print('sizefile writing', SerialIO.GetPort())
    try:
        fh = open(SizeFile,'w')
        fh.writelines('Ps;' + str(ax) +';' + str(ay) + ';\n')
        if pfad != None:
            fh.writelines('Fp;' + pfad +';\n')
            fh.writelines('Si;' + SerialIO.GetPort() + ';\n')
            fh.writelines('Ac;' + str(Adrconv) + ';\n')
            fh.writelines('Rc;' + str(RouteClass) + ';\n')
            fh.writelines('Tt;' + Ttfile +';\n')
            
        fh.close()
    except:
        print('size file not writeable')


#--------------------------------------------------------

def parserStar(cnt):
    #Zerlegen der Zeilen mit *
    for p in range(cnt):              # *, Weichen
        B = RDstr.getStar(p)
        if B[1] != 0:                 # unklar, aber notwendig
            Stp[int(B[1])][int(B[0])].Sel    = 'W'
            Stp[int(B[1])][int(B[0])].N      = str(B[2])
            Stp[int(B[1])][int(B[0])].DA     = int(B[3])
            Stp[int(B[1])][int(B[0])].U      = int(B[4])
            Stp[int(B[1])][int(B[0])].Lage   = int(B[5])
            Stp[int(B[1])][int(B[0])].WState = int(0)
            Stp[int(B[1])][int(B[0])].inFstr = False
            Stp[int(B[1])][int(B[0])].WStcd  = int(0) #DKW State cd
    return

def parserSig(cnt):
    #Zerlegen von &;S; Signale
    for p in range(cnt):              # &;S; Signale
        B = RDstr.getSig(p)
        if B[0] == 'S':
            Stp[int(B[2])][int(B[1])].Sel  = 'S'
            Stp[int(B[2])][int(B[1])].N         = str(B[3])
            Stp[int(B[2])][int(B[1])].ST        = int(B[4])
            Stp[int(B[2])][int(B[1])].DA        = int(B[5])
            Stp[int(B[2])][int(B[1])].Rm        = int(0)
            Stp[int(B[2])][int(B[1])].Hpstate   = 'Hp0'
            Stp[int(B[2])][int(B[1])].Shstate   = 'Sh0'
            Stp[int(B[2])][int(B[1])].inFstr    = False
            Stp[int(B[2])][int(B[1])].FstrStart = False
            Stp[int(B[2])][int(B[1])].FstrEnde  = False
            Stp[int(B[2])][int(B[1])].FstrZR    = ''
            Stp[int(B[2])][int(B[1])].FstrEndZR = ''
            Stp[int(B[2])][int(B[1])].Zv        = [0,0]
            Stp[int(B[2])][int(B[1])].Zr        = [0,0] #Startsignal
            Stp[int(B[2])][int(B[1])].LokStop   = 0     #Lokadresse am Zielsignal
            Stp[int(B[2])][int(B[1])].Stopmsg   = False #Stopmeldung an Lokfenster
            Stp[int(B[2])][int(B[1])].Vhalbexy  = [0,0] #Check next Hp
            
    return

def parserTxt(cnt):
    #Zerlegen von &;t; Text
    for p in range(cnt):              # &;t; Infotext oder Link
        B = RDstr.getTxt(p)
        if B[0] == 't':
            Stp[int(B[2])][int(B[1])].Sel    = 't'
            Stp[int(B[2])][int(B[1])].N      = str(B[3])
            Stp[int(B[2])][int(B[1])].Rm     = int(0)
            Stp[int(B[2])][int(B[1])].BuddyX = int(-1) #Link
            Stp[int(B[2])][int(B[1])].BuddyY = int(-1)
            Stp[int(B[2])][int(B[1])].inFstr = False
    return

def parserImel(cnt):
    #Zerlegen von &;i; Melder versch.Farben
    global GelbX, GelbY
    global OkerX, OkerY
    global GreenX,GreenY
    global Green1
    global Gray1
    global Gray2
    global Gray3
    global Red1
    global SerTile
    global ArdTile
    global RCLtile
    global TCtile
    global Tttile
    global ZLtile
    global Ttfile
    
    for p in range(cnt):             # &;i; Typ
        B = RDstr.getTxt(p)
        if B[0] == 'i':
            Stp[int(B[2])][int(B[1])].Sel  = 'i'
            Stp[int(B[2])][int(B[1])].T    = int(B[3])
            Stp[int(B[2])][int(B[1])].Mul  = int(B[4])
            
            if int(B[3]) == 1:           #Messagetile Gelb
                GelbX = int(B[1])
                GelbY = int(B[2])
                SerTile = True                
                print('Serial Tile exist:',SerTile)
                
            elif int(B[3]) == 2:        #Messagetile oker
                OkerX = int(B[1])
                OkerY = int(B[2])
                ArdTile = True                
                print('Arduino Tile exist:',ArdTile)

            elif int(B[3]) == 4:        #RouteClasstile green
                if int(B[4]) == 1:      #Release
                    print('Release Tile exist:')
                    Green1 = [int(B[1]),int(B[2])]                    
                else:                   #Route Class
                    GreenX = int(B[1])
                    GreenY = int(B[2])
                    RCLtile = True
                    print('RCL Tile exist:',RCLtile)

            elif int(B[3]) == 6:        #RouteClasstile gray
                if int(B[4]) == 1:      #Timer/Clock
                    Gray1 = [int(B[1]),int(B[2])]
                    TCtile = True
                    print('Tim/cnt Tile exist:',TCtile)
                                        
                elif int(B[4]) == 2:    #Tt hold
                    Gray2 = [int(B[1]),int(B[2])]
                    Tttile = True
                    print('Tt hold Tile exist:',Tttile)
                elif int(B[4]) == 3:    #ZL Tile
                    Gray3 = [int(B[1]),int(B[2])]
                    ZLtile = True
                    print('ZL hold Tile exist:',ZLtile)                

            elif int(B[3]) == 5:        #Signal Red Departure
                if int(B[4]) == 1:      #Departure
                    Red1 = [int(B[1]),int(B[2])]
                    Deptile = True
                    print('Departure Tile exist:',Deptile)                                 
                
    return


def parserFweg(cnt, Fweg):
    #Zerlegen von &;b; Fwegtasten
    bcnt = 0
    for p in range(cnt):             # &;b; Typ
        B = RDstr.getTxt(p)
        if B[0] == 'b':
            Fw = '' if bcnt >= len(Fweg) else Fweg[bcnt]
            Stp[int(B[2])][int(B[1])].Sel  = 'b'
            Stp[int(B[2])][int(B[1])].N    = str(B[3])
            Stp[int(B[2])][int(B[1])].Fw   = Fw
            bcnt += 1
    return

def parserKdec(cnt):
    #Zerlegen von &;K; Schaltdecoder
    for p in range(cnt):             # &;K; Typ
        B = RDstr.getTxt(p)
        if B[0] == 'K':
            Stp[int(B[2])][int(B[1])].Sel    = 'K'
            Stp[int(B[2])][int(B[1])].N      = str(B[3])
            Stp[int(B[2])][int(B[1])].T      = int(B[4])
            Stp[int(B[2])][int(B[1])].DA     = int(B[5])
            Stp[int(B[2])][int(B[1])].Kstate = int(0)
    return

def parserRmel(cnt):
    # Zerlegen von &;R; Rückmelder für Ele 1,2,3
    # und für Signale auf Ele 1,2,3
    
    for p in range(cnt):             # &;R; Typ
        B = RDstr.getTxt(p)
        if B[0] == 'R':
            Rm[int(B[3])][0] = int(B[1])
            Rm[int(B[3])][1] = int(B[2])
            #print('Rm ---------',B[3],'at',B[1],B[2])
            Sel = Stp[int(B[2])][int(B[1])].Sel
            if Sel == 'S' or Sel == 't' :
                Stp[int(B[2])][int(B[1])].Rm = int(B[3])
                #print('Rm auf x,y:', B[3],B[1],B[2])
                #Rm[int(B[3])] = int(B[1]),int(B[2])
                Rm[int(B[3])][0] = int(B[1])
                Rm[int(B[3])][1] = int(B[2])       
    return

#-------------------------------------------------------------

def csv2pic(canvas, elearr, cnt, Fweg):

    for y in range(dim_y):
        for x in range(dim_x):
            ele = elearr[y][x]
            if ele[:1] == 'G':
                ele = ele[1:]
                Stp[y][x].EleG = True # Gleisperre
            try:
                ele = int(ele)
            except ValueError:
                ele = 0
            Stp[y][x].Ele = int(ele)
            Stp[y][x].Sel = str('')
            Stp[y][x].Redraw = bool(True)

    parserSig(cnt)
    parserStar(cnt)
    parserTxt(cnt)
    parserImel(cnt)
    parserFweg(cnt, Fweg)
    parserKdec(cnt)
    parserRmel(cnt)    # Markierung RM im Abschnitt

    updateDrawings(canvas)

#--------------------------------------------------------
    
def findoneFweg(fw):
    fwko = [0,0]
    io   = False
    for y in range(ElanzY):
        for x in range(ElanzX):                
            e = Stp[y][x]                
            if e.Sel == 'b' and e.N == fw:
                fwko = [x,y]
                print('Fweg:',e.N,e.Fw)
                a_split = e.Fw.split(';')
                Wcnt = len(a_split) - 2
                io = Wsearch(a_split,Wcnt)                
                if io == False:
                    print('Fweg konnte nicht eingestellt werden')    
    return fwko,io


def findoneHpSig(sig):
    sigko = [0,0]
    for y in range(ElanzY):
        for x in range(ElanzX):                
            e = Stp[y][x]                
            if e.Sel == 'S' and e.N == sig:
                sigko = [x,y]

    return sigko
    

def findSignals():      # Signalantriebe bei Quit auf 0: -(e.DA),Wswitch()
    scnt = 0
    swit = 0
    for y in range(ElanzY):
        for x in range(ElanzX):                
            e = Stp[y][x]                
            if e.Sel == 'S':                
                scnt += 1
                if e.ST in range(26,28):
                    #print('Signal:',e.N,e.Hpstate,e.Shstate, e.DA,e.DA+1)
                    if e.Hpstate != 'Hp0':                        
                        SigChkF(x,y)
                        swit += 1
                    if e.Shstate != 'Sh0':                        
                        SigChkR(x,y)
                        swit += 1
                elif e.ST in range(28,30):
                    #print('Signal:',e.N,e.Hpstate)
                    if e.Hpstate != 'Hp0':                        
                        SigChkF(x,y)
                        swit += 1
                    
                elif e.ST in range(30,32):
                    #print('Signal:',e.N,e.Shstate)
                    if e.Shstate != 'Sh0':                        
                        SigChkR(x,y)
                        swit += 1
                            
    print('signals with dig Adr., switched:',scnt,swit)            

#--------------------------------------------------------

def writeLocoID(pfad):

    try:
        fh = open(LocIDFile,'w')
        
        for y in range(ElanzY):
            for x in range(ElanzX):                
                e = Stp[y][x]                
                if e.Sel == 'S':
                    if e.Rm != 0 and e.LokStop != 0:
                        print('Signal:',e.N, e.Rm, e.LokStop)
            
                        fh.writelines(e.N +',' + str(e.Rm) +',' + str(e.LokStop) + ',\n')
                        
        print(LocIDFile,'saved')
        fh.close()
    except:
        print('LocoID file not writeable')



def readLocoID():

    try:
        fh = open(LocIDFile, 'r')
        while True:
            idline = fh.readline()
            if not idline:
                fh.close()
                print('closed:',LocIDFile)
                break
            d_split = idline.split(',')
            if DebugID: print(d_split)

            TimetabNewLok(0,d_split[0],d_split[2])     

        fh.close()

    except:
        print('no',LocIDFile)
        
#--------------------------------------------------------
"""       

"""
#--------------------------------------------------------

def frameOnClose():
    global pfad
    global update_id
    global RouteClass
    
    findSignals()

    writeLocoID(pfad)
    
    print("close, path:",pfad)
    writeSize(ElanzX,ElanzY,pfad,Adrconv,RouteClass)
    
    if (ChgFlag == 0 or
        messagebox.askokcancel("Quit",
                               "There are unsaved changes.\nDo you really want to quit?",
                               default='cancel')):
        SerialIO.Terminate()
        if timer_id:
            root.after_cancel(timer_id)   # Timer abbrechen
            time.sleep(1)
        
        root.destroy()

#--------------------------------------------------------
def Sigstopdelete():
    print("*** Arduino Start or reset")
    for y in range(ElanzY):
        for x in range(ElanzX):                
            e = Stp[y][x]                
            if e.Sel == 'S' and e.Rm != 0 and e.LokStop != 0:
                print("Lokstop at Signal delete",e.N)
                e.LokStop = 0
                if e.ST in [27,29,31]:  #Loktext unten
                    Draw.rect(canvas,TABLE,[(x*elx+offsx+1,y*ely+offsy+1+25),(elx-1,14)])                    
                else:                   #loktext oben
                    Draw.rect(canvas,TABLE,[(x*elx+offsx+1,y*ely+offsy+1),(elx-1,14)])
            
                

def frameOnSerialReceived(self):
    global ucnt
    global update_id
    global sinState
    global lastRm
    global XBusok
    global copmov
    
    Lines = SerialIO.GetReceived().splitlines()
    for Line in Lines:
        #print("ser-received:", len(Line), "Bytes <" + Line + ">")
        
        if ArdTile:
            ucnt += 1
            Draw.rect(canvas,OKER,[(OkerX*elx+offsx+1,OkerY*ely+offsy+1),(60,40)])
            if XBusok:
                Draw.circle(canvas,WHITE,(OkerX*elx+offsx+elx/2,OkerY*ely+offsy+ely/2+7) ,8)
            else:
                Draw.circle(canvas,GRAY,(OkerX*elx+offsx+elx/2,OkerY*ely+offsy+ely/2+7) ,8)
                
            if ucnt & 0x01 == True:
                color = WHITE
            else:
                color = BLACK

            msk = 0
            if copmov == 1:             #Test
                msk = 0xF0000000
            elif copmov == 2:
                msk = 0x10000000
            
            if Line.isdigit():
                #Line = int(Line) | msk    #Test
                Hxline = "x%08X" % int(Line)
                Draw.text(canvas,color,(OkerX*elx+offsx+elx/2,OkerY*ely+offsy+7),font,Hxline,True)
                actRm = int(Line)
                if actRm != lastRm:
                    bitnumber(actRm,lastRm)
                    lastRm = actRm
                    print('change RM',"0x%08X" % actRm)

            elif Line == "Start Ard.":
                Sigstopdelete()
                rdLocoFV()
                retypeVinLtab() # change 'V' to 0
                readLocoID()

            elif Line == "_0Power ok":
                XBusok = True
                print(Line)
                Draw.circle(canvas,WHITE,(OkerX*elx+offsx+elx/2,OkerY*ely+offsy+ely/2+7) ,8)
                Draw.text(canvas,color,(OkerX*elx+offsx+elx/2,OkerY*ely+offsy+7),font,Line,True)
                
            elif Line == "_2Notaus":
                XBusok = False
                Draw.circle(canvas,GRAY,(OkerX*elx+offsx+elx/2,OkerY*ely+offsy+ely/2+7) ,8)
                Draw.text(canvas,color,(OkerX*elx+offsx+elx/2,OkerY*ely+offsy+7),font,Line,True)

            elif Line == "XB_Run" or Line == "LN_Run":
                XBusok = True                
                Draw.circle(canvas,WHITE,(OkerX*elx+offsx+elx/2,OkerY*ely+offsy+ely/2+7) ,8)
                Draw.text(canvas,color,(OkerX*elx+offsx+elx/2,OkerY*ely+offsy+7),font,Line,True)

            elif Line == "XB_Hold" or Line == "LN_Hold":
                XBusok = False
                Draw.circle(canvas,GRAY,(OkerX*elx+offsx+elx/2,OkerY*ely+offsy+ely/2+7) ,8)
                Draw.text(canvas,color,(OkerX*elx+offsx+elx/2,OkerY*ely+offsy+7),font,Line,True)

            elif Line[0] == '*' and copmov == 2:
                print('MM Info:',Line)
                txp =  520
                Draw.rect(canvas,WHITE,[(txp,8),(60,20)])               
                Draw.text(canvas,BLACK,(txp+30,16),font,Line[:10],True)
                                
            else:
                if Line[0] != '*':
                    Draw.text(canvas,color,(OkerX*elx+offsx+elx/2,OkerY*ely+offsy+7),font,Line[:10],True)                

            SimuState(sinState,XBusok)
            
      
                    

def frameOnSerialState(data):
    updateSerialState(canvas)



#--------------------------------------------------------        

def WeicheState(x,y,e):
    
    Gerade = 1
    Bogen  = 2

    if e.inFstr:
        print('Weiche in Fahrstraße nicht stellbar')
        
    else:    
        if e.Ele in range (16,20):              #EW
            if DebugFs: print('Ele, Adr, Wstate:',e.Ele,e.DA,e.WState)
            Wadr = e.DA
            if e.WState == 0:
                e.WState = Gerade
            elif e.WState == Gerade:
                e.WState = Bogen
                Wadr = -Wadr
            elif e.WState == Bogen:
                e.WState = Gerade

            if DebugFs: print('Ele, Adr, Wstate:',e.Ele,e.DA,e.WState)
            Draw.DrawSwitchStand(x,y,e.Ele,e.WState,canvas)
            SerialIO.Wswitch(Wadr,e.Lage)

        elif e.Ele in range (8,12):              #EW Diagonal
            Wadr = e.DA
            if e.WState == 0:
                e.WState = Gerade
            elif e.WState == Gerade:
                e.WState = Bogen
                Wadr = -Wadr
            elif e.WState == Bogen:
                e.WState = Gerade

            Draw.DrawDiagonalStand(x,y,e.Ele,e.WState,canvas)
            SerialIO.Wswitch(Wadr,e.Lage)
                
        elif e.Ele in range (24,26):            #DW Doppelweiche
            e.WState = Draw.DrawDWStand(x,y,e.Ele,e.DA,e.Lage,e.WState,canvas)

        elif e.Ele in range (12,14):            # DKW
            e.WState,e.WStcd = Draw.DrawSwDKW(x,y,e.Ele,e.DA,e.Lage,e.WState,e.WStcd,DKWside,canvas)
            
#--------------------------------------------------------

def Wsearch(a_split,anzW):
    # durchsuche für jedes Elemen aus a_split die ganze Matrix
    found = False
    for i in range(anzW):
        Wsuch = a_split[i+1]            
        
        for y in range(ElanzY):
            for x in range(ElanzX):                
                e = Stp[y][x]                
                if e.Sel == 'W':                        
                    if int(e.DA) == abs(int(Wsuch)):
                        if e.inFstr:
                            print('Weiche',e.N,'in Fstr, nicht stellbar')                            
                            return False
                        
                        else:                                
                            found = True
                            
                            if e.Ele in range (12,14):      # DKW                                   
                                Fweg_DKW(Wsuch,a_split,i,e,x,y)                                   
                                
                            elif e.Ele in range (24,26):    # Doppelweiche
                                Fweg_DW(Wsuch,a_split,i,e,x,y)

                            else:                           # Einfache Weiche
                                Fweg_EW(Wsuch,e,x,y)                                       
    return found


def Fweg_EW(Wsuch,e,x,y):
    if DebugFs: print('EW-Name,Opt,State,Adr',e.N,e.Lage,e.WState,e.DA)
    # kein init, gleich Lage Stellen, immer eine Position stellen

    Adr = e.DA
    
    if e.WState == 0:                           # Init
        if int(Wsuch) < 0:
            e.WState = 2
            Adr = -Adr
        else:
            e.WState = 1
        
        if e.Ele in range (16,20):              #EW
            Draw.DrawSwitchStand(x,y,e.Ele,e.WState,canvas)
            SerialIO.Wswitch(Adr,e.Lage)

        elif e.Ele in range (8,12):             #EW Diagonal     
            Draw.DrawDiagonalStand(x,y,e.Ele,e.WState,canvas)
            SerialIO.Wswitch(Adr,e.Lage)


    else:                                       # Stellen?
        EWsoll = 1
        if int(Wsuch) < 0:
            EWsoll = 2

        if e.WState == EWsoll:
            if DebugFs: print('EW Lage korrekt')            # nein
        else:
            if DebugFs: print('EW falsche Lage')            # ja
            if e.WState == 1:
                e.WState = 2
                Adr = -Adr
            else:
                e.WState = 1

            if e.Ele in range (16,20):          #EW
                Draw.DrawSwitchStand(x,y,e.Ele,e.WState,canvas)
                SerialIO.Wswitch(Adr,e.Lage)

            elif e.Ele in range (8,12):         #EW Diagonal     
                Draw.DrawDiagonalStand(x,y,e.Ele,e.WState,canvas)
                SerialIO.Wswitch(Adr,e.Lage)


def Fweg_DW(Wsuch,a_split,i,e,x,y):
    if DebugFs: print('Doppelweiche Position',e.WState)                                    

    swp0 = 0
    swp1 = 0
    if e.Lage == 1:
        swp0 = 1
    elif e.Lage == 2:
        swp1 = 1
    elif e.Lage == 3:
        swp0 = 1
        swp1 = 1

    if e.WState == 0:                                 #wenn 0, dann ==
        e.WState = 2
        
        if e.Ele == 24:
            Draw.TurnoutDir(x,y,2,WHITE,canvas)
        else:
            Draw.TurnoutDir(x,y,1,WHITE,canvas)
        SerialIO.Wswitch(e.DA,swp0)
        SerialIO.Wswitch(-(e.DA+1),swp1)
    
    if DebugFs: print('Weiche 1', Wsuch)
    Weiche2 = int(a_split[i+2])
    i += 1
    if DebugFs: print('Weiche 2',Weiche2)

    if DebugFs: print('alte Lage:',e.WState)

    if int(Wsuch) < 0 and Weiche2 > 0:
        newState = 1
    elif int(Wsuch) > 0 and Weiche2 > 0:
        newState = 2
    elif int(Wsuch) > 0 and Weiche2 < 0:
        newState = 3
    else:
        print('Fehler Fweg')

    if DebugFs: print('neue Lage:',newState)

    if e.WState != newState:
        e.WState = newState
        Draw.DWnewState(x,y,e.Ele,e.DA,e.WState,swp0,swp1,canvas)


def Fweg_DKW(Wsuch,a_split,i,e,x,y):
    if e.Lage in [4,5]:
        if DebugFs: print('DKW mit einem Antrieb')
        Fweg_DKW1A(Wsuch,e,x,y)

    else:        
        swpab = 0
        swpcd = 0
        if e.Lage == 1:
            swpab = 1
        elif e.Lage == 2:
            swpcd = 1
        elif e.Lage == 3:
            swpab = 1
            swpcd = 1
            
        # Lage lesen
        if DebugFs: print('Name,Opt,State,Adr',e.N,e.Lage,e.WState,e.DA)
        if DebugFs: print('Name,Opt,St_cd,Adr',e.N,e.Lage,e.WStcd,e.DA+1)

        if e.WState == 0:
            e.WState = 1
            e.WStcd  = 1
            Draw.TurnoutDir(x,y,0,WHITE,canvas)
            SerialIO.Wswitch(e.DA,swpab)
            Draw.TurnoutDir(x,y,2,WHITE,canvas)
            SerialIO.Wswitch(e.DA+1,swpcd)
        
        ab_soll = 1
        if int(Wsuch) < 0:
            ab_soll = 2
            
        if e.WState == ab_soll:                                    
            if DebugFs: print('a/b korrekt')
        else:
            if DebugFs: print('a/b falsche Lage',e.WState)
            e.WState = Draw.statePic_ab_update(x,y,e.Ele,e.WState,e.DA,swpab,canvas)
            if DebugFs: print('neue Lage a/b:',e.WState)

        cd_soll = 1              # Antrieb cd nicht suchen, ist nur in Fweg
        if int(a_split[i+2]) < 0: # nur VZ von cd
            cd_soll = 2
        i += 1
        
        if e.WStcd == cd_soll:
            if DebugFs: print('c/d korrekt')
        else:
            if DebugFs: print('c/d falsche Lage:',e.WStcd)
            e.WStcd = Draw.statePic_cd_update(x,y,e.Ele,e.WStcd,e.DA,swpcd,canvas)  
            if DebugFs: print('neue Lage c/d:',e.WStcd)
            

def Fweg_DKW1A(Wsuch,e,x,y):
    #print('DKW1A-Name,Opt,State,Adr',e.N,e.Lage,e.WState,e.DA)
    Adr = e.DA
    
    swap = 0
    if e.Lage == 5:
        swap = 1        
    
    if e.WState == 0:                           # Init
        Draw.DrawDKW1Astand(x,y,e.Ele,e.WState,canvas)
        
        if int(Wsuch) < 0:
            e.WState = 2
            Adr = -Adr
        else:
            e.WState = 1

        Draw.DrawDKW1Astand(x,y,e.Ele,e.WState,canvas)
        SerialIO.Wswitch(Adr,swap)

    else:                                       # stellen?
        EWsoll = 1
        if int(Wsuch) < 0:
            EWsoll = 2

        if e.WState == EWsoll:
            if DebugFs: print('DKW1A Lage korrekt')         # nein

        else:
            if DebugFs: print('DKW1a falsche Lage')         # ja, stellen
            if e.WState == 1:
                e.WState = 2
                Adr = -Adr
            else:
                e.WState = 1
        
            Draw.DrawDKW1Astand(x,y,e.Ele,e.WState,canvas)          
            SerialIO.Wswitch(Adr,swap)        

    
       
        
#--------------------------------------------------------

def mouseMoveEvent(event):
    txp = (ElanzX * elx) - 20
    Draw.rect(canvas,TABLE,[(txp,8),(60,20)])
    if event.y >= offsy:
        posX = int((event.x-offsx)/elx)
        posY = int((event.y-offsy)/ely)
        if (posY < ElanzY and posX < ElanzX):
            Element = Stp[posY][posX].Ele
            st = str(posX) + "/" + str(posY)
            Draw.text(canvas,BLACK,(txp,8),font,st)
            Draw.text(canvas,BLACK,(int(txp+elx/2),8),font,str(Element))

#--------------------------------------------------------

def mouseButtonPressEvent(event):
    global DebugFs
    
    if DebugFs: print(f"MouseButtonPress #{event.num}: {event.x} : {event.x}")
    menue_i = -1
    if event.y >= 0 and event.y <= 39:  #Menu
        for i in range(len(menu)):
            if (event.x >= menuoffsets[i] and event.x <= menuoffsets[i+1]):
                menue_i = i    # Auswertung bei Buttonpressed
    posX = min(max(0, int((event.x-offsx)/elx)), ElanzX-1) # with clamp
    posY = min(max(0, int((event.y-offsy)/ely)), ElanzY-1) # with clamp

    

        #fieldt = 'Name', 'Twice Dig.a', 'Type', 'Option'

  

#--------------------------------------------------------

    

    def getPathrd():
        hide = Tk()
        hide.withdraw()
        #filetypes = [('stw files','*.csv;*.txt')]
        filetypes = [('stw files', '*.csv'), ('stw files', '*.txt')]
        pfad = filedialog.askopenfilename(filetypes=filetypes)
        hide.destroy()
        return pfad
#--------------------------------------------------------
    def KeySwitch(x,y):
        e = Stp[y][x]        
        ex = int(x * elx + offsx + elx/2)
        ey = int(y * ely + offsy + ely/2)

        Adr = e.DA

        if e.Kstate == 0:
            e.Kstate = 'off'
            Adr = -Adr
            
        elif e.Kstate == 'off':
            e.Kstate = 'on'
            
            
        elif e.Kstate == 'on':
            e.Kstate = 'off'
            Adr = -Adr

        if e.Kstate == 'on':
            Draw.circle(canvas,WHITE,(ex,ey),8)
        else:
            Draw.circle(canvas,DGRAY,(ex,ey),8)
            
        print('Decoder:',e.N,e.DA,e.Kstate)

        if Adr != 0:
            SerialIO.Wswitch(Adr,0)
            
    #----------------------------------------------------

    def FwegSwitch(x,y):
        e = Stp[y][x]
        print('Taste, Fweg:',e.N,e.Fw)
        a_split = e.Fw.split(';')
        Wcnt = len(a_split) - 2
        
        #print('Anzahl Weichen im Fweg',Wcnt)
        
        #print('a last:',a_split[len(a_split)-2])

        print('Suche:',Wsearch(a_split,Wcnt))

#--------------------------------------------------------

    
#--------------------------------------------------------
    global fname
    global zname
    global px1
    global py1
    global px2
    global py2
    global pfad
    global Ttfile
    global ZLfile
    global DKWside
    global GelbX, GelbY
    global cmd
    global Ttactive
    global ZLtab
    global ZLqueue
    global ZLtile
    
    
    if event.num==1:     # Mouse Taste links

        if menue_i >= 0:
            print("MenueNr",menue_i)
            if menue_i == 0 and (ChgFlag == 0 or
              messagebox.askokcancel("Load",
                                     "Your unsaved changes will be lost.\nContinue anyway?",
                                     default='cancel')):
                print("Laden ")
                pfad = getPathrd()
                print("path:",pfad)
                IOerr = False
                try:
                    fh = open(pfad, encoding='utf-8')
                except:
                    IOerr = True
                    print("Abbruch open file")

                if not IOerr:
                    clearAll()

                    fname = ntpath.basename(pfad)
                    showFilename(canvas, fname)
                    print("Datei geöffnet:",fname)

                    elearr,cnt = RDstr.RDcsv(fh)
                    fh.close()

                    print("Zeilen:",cnt)

                    Fweg = RDstr.getFweg()
                    print('Anzahl Fwege: ', len(Fweg))

                    csv2pic(canvas, elearr, cnt, Fweg)
                    LinkSearch()

                    Rm_refresh()
                    
#-----------------------------------------------------------------------------
                    

            if menue_i == 1:
                print("save not implemented")


            if menue_i == 2:
                print("Load Tt-File, alt:",Ttfile)
                if Ttactive == False:
                    Tpfad = getPathrd()
                    if Tpfad == "":
                        print('nicht neu, Tt-Datei:',Ttfile)
                    else:
                        print("neu path:",Tpfad)
                        Ttfile = Tpfad
                    Tx = Gray1[0]
                    Ty = Gray1[1]
                    fname = ntpath.basename(Ttfile)
                    Draw.rect(canvas,LGRAY,[(Gray1[0]*elx+offsx+1,Gray1[1]*ely+offsy+1),(60,40)])
                        #alles wg. Content Error löschen
                    Draw.textInfo(Tx,Ty,0,fname[0:9],2,font,font14,canvas)
                        
                else:
                    print("Tt must be off")
                
#-----------------------------------------------------------------------------
                
            elif menue_i == 3:
                if ZLtile:          #Gray3 exist
                    Zlines = 0
                    print("Load Zuglenk-File, alt:",ZLfile)
                    Zpfad = getPathrd()
                    if Zpfad == "":
                        print('nicht neu, ZL-Datei:',ZLfile)
                    else:
                        print("neu path:",Zpfad)
                        ZLfile = Zpfad
                    
                        Zlines = RdZLdat(ZLfile)
                        zname = ntpath.basename(ZLfile)     #global
                        Zx = Gray3[0]
                        Zy = Gray3[1]

                        Draw.rect(canvas,LGRAY,[(Zx*elx+offsx+1,Zy*ely+offsy+27),(elx-1,14)])
                        Draw.textInfo(Zx,Zy,0,zname[0:9],2,font,font14,canvas)

                        
                    print('zname,ZL-Lines:',zname,Zlines)
                    
                else:
                    print("ZLtile missing")
                
#-----------------------------------------------------------------------------
            elif menue_i == 4:

                
                def OkOnClick():
                    SerialIO.SetPort(etEingabe.get())
                    fenster.destroy()

                def CancelOnClick():
                    fenster.destroy()

                fenster = tk.Toplevel(root)
                
                fenster.title("Eingabe IF")
                fenster.resizable(0, 0)

                
                
                lbEingabe = tk.Label(fenster,text="Serial Interface:")
                lbEingabe.grid(row=0, column=0, sticky="w", padx=5, pady=5)

                etEingabe = tk.Entry(fenster)
                etEingabe.grid(row=1, column=0, padx=5, pady=5)
                etEingabe.insert(END, SerialIO.GetPort())

                lbAusgabe = tk.Label(fenster,text=Platform)
                lbAusgabe.grid(row=2, column=0, sticky="w", padx=5, pady=5)

                buEnde = tk.Button(fenster, text="Cancel", command=CancelOnClick, width=10)
                buEnde.grid(row=3, column=0, sticky="e", padx=5, pady=5)

                buverd = tk.Button(fenster, text="OK",
                                   command=OkOnClick, width=10)
                buverd.grid(row=3, column=1, sticky="e", padx=5, pady=5)

                fenster.bind("<Escape>", lambda x: fenster.destroy())
                #showModal(fenster)
                fenster.transient(root)

                

#-----------------------------------------------------------------------------

            elif menue_i == 5:         #hier State ändern, Ausführung MT M
                global MoveState
                global copmov
                if MoveState != 0:
                    mmcResetState(canvas)
                else:
                    copmov = (copmov+1)%3                    
                    mmcUpdateLabel(canvas)
                    if copmov == 1:
                        txp =  520
                        Draw.rect(canvas,TABLE,[(txp,8),(60,20)])    
                        

#-----------------------------------------------------------------------------
        else:                               #Maustaste Links
            global DKWside
            global Signal_ZR
            global sinState
            global ser
            global RouteClass
            global RelbyTrain
            global SignalDep
            global qLokHp1
            global GrauFeld            
            global Gray2
            #global Gray3
            global Red1
            global Green1
            global TCtile
            global Tttile
            global TttileState            
            global TimerA
            global Ttindex
            global ZLtab
            global ZLqueue
            global ZLactive
            
                        
            print("posxy:",posX,posY)       #debug            
            e = Stp[posY][posX]
            #print(e)
            if e.Sel == '':
                print("- leer -")
                print(e.Ele)
            
            else:
                Wzeig = e.Sel
                sel = Wzeig[0]
                #print('Selektor:',sel)
                if sel == 'W':
                    WeicheState(posX,posY,e)
                    
                elif sel == 'i':
                    if e.T == 3:            # Feld blau                        
                        if DKWside == 'a/b':
                            DKWside = 'c/d'
                        else:
                            DKWside = 'a/b'
                        
                        Draw.rect(canvas,LBLUE,[(posX*elx+offsx+1,posY*ely+offsy+1),(60,40)])
                        Draw.text(canvas,BLACK,(posX*elx+offsx+elx/2,posY*ely+offsy+ely/2),font14,DKWside,True) 
                        
                        
                    elif e.T == 5:          # Feld rot
                        if e.Mul == 0:      # Zugf/Ranf
                            Draw.rect(canvas,RED,[(posX*elx+offsx+1,posY*ely+offsy+1),(60,40)])
                            if Signal_ZR == 'Zugf':
                                Signal_ZR = 'Ranf'
                                Draw.text(canvas,WHITE,(posX*elx+offsx+elx/2,posY*ely+offsy+ely/2),font14,Signal_ZR,True)
                            else:
                                Signal_ZR = 'Zugf'
                                Draw.text(canvas,BLACK,(posX*elx+offsx+elx/2,posY*ely+offsy+ely/2),font14,Signal_ZR,True)                        

                        elif e.Mul == 1:    # Departure                            
                            if SignalDep:
                                SignalDep = False                                
                            else:
                                SignalDep = True
                            SigDeparture(SignalDep)
                                

                    elif e.T == 1:          # Feld gelb                       
                        print("Gelbes Feld", GelbX,GelbY)
                        Draw.textInfo(GelbX,GelbY,0,'SerialIF',1,font,font14,canvas)
                        #readLocoID()
                       

                    elif e.T == 2:          # Feld oker
                        print("Oker Feld", OkerX,OkerY)
                        
                    elif e.T == 4:          # Feld grün
                        if e.Mul == 0:
                            print("Route Feld", GreenX,GreenY)
                            
                            RouteClass += 1
                            if RouteClass > 2:
                                RouteClass = 0
                                if Ttactive: Ttresume()    # Timetable aus
                                
                            if RouteClass == 1:
                                findSignals()   # Alle Signale Hp0 und Sh0
                                
                            Draw.rect(canvas,GREEN,[(posX*elx+offsx+1,posY*ely+offsy+1),(60,40)])
                            Draw.textInfo(GreenX,GreenY,0,'Route CL',1,font,font14,canvas)
                            Draw.text(canvas,BLACK,(posX*elx+offsx+elx/2,posY*ely+offsy+5+ely/2),font14,RouteClass,True)
                            
                        elif e.Mul == 1:
                            print('Release Feld')
                            Draw.rect(canvas,GREEN,[(posX*elx+offsx+1,posY*ely+offsy+1),(60,40)])
                            if RelbyTrain:
                                RelbyTrain = False
                                Draw.textInfo(posX,posY,0,'Operator',0,font,font14,canvas)
                            else:
                                RelbyTrain = True
                            Draw.textInfo(posX,posY,0,'R.release',1,font,font14,canvas)
                            Draw.textInfo(posX,posY,0,'by Train',2,font,font14,canvas)

                    elif e.T == 6:          # Feld grau
                        print("Grau Feld",posX, posY)
                        
                        if e.Mul == 0:      # Optionswahl 
                            GrauFeld += 1
                            if GrauFeld > 3:
                                GrauFeld = 0
                            Draw.rect(canvas,LGRAY,[(posX*elx+offsx+1,posY*ely+offsy+1),(60,40)])
                            Draw.textInfo(posX,posY,0,'Option',1,font,font14,canvas)
                            DrawOption(posX, posY, GrauFeld)                             
                                
                        elif e.Mul ==1:
                            if ZLactive:
                                print('ZLactive, Tt rejected')
                            else:
                                print("Grau Feld Timer/Clock",Gray1[0],Gray1[1])                            
                                if Ttactive:                                
                                    Ttstateoff()
                                else:
                                    Ttactive = True
                                    if RouteClass > 0:
                                        rcode = RdTtdat(Ttfile)
                                        if rcode > 0:
                                            TimerA  = 0
                                            Ttindex = 0
                                            TttileState = 1    # Zeitzähler aus
                                            fname = ntpath.basename(Ttfile)
                                            Draw.textInfo(posX,posY,0,'Tt on',0,font,font14,canvas)
                                            Draw.rect(canvas,LGRAY,[(posX*elx+offsx+1,posY*ely+offsy+1),(elx-1,14)])                                            
                                            Draw.text(canvas,BLACK,(posX*elx+offsx+30,posY*ely+offsy+8),font,'0:00:00',True)                                           
                                            Draw.textInfo(posX,posY,0,fname[0:9],2,font,font14,canvas)
                                            if Tttile:
                                                Draw.textInfo(Gray2[0],Gray2[1],0,'Stop',0,font,font14,canvas)
                                            
                                        elif rcode < 0:
                                            Ttstateoff()
                                            TttileState = 1    # Zeitzähler aus
                                            Draw.rect(canvas,LGRAY,[(posX*elx+offsx+1,posY*ely+offsy+27),(elx-1,0)])
                                            Draw.text(canvas,BLACK,(posX*elx+offsx+30,posY*ely+offsy+8),font,'Cont.Err',True)                                            
                                           
                                        else:
                                            Ttstateoff()                                            
                                            Draw.textInfo(posX,posY,0,'no File',2,font,font14,canvas)
                                            
                                        
                        elif e.Mul == 2:                            
                            print("Grau Feld Tttile")
                            if Ttactive:
                                if TttileState == 2: # Resume
                                    Draw.textInfo(posX,posY,0,'Run',0,font,font14,canvas)
                                    SigDeparture(False)
                                    TimerA -= 2
                                    TttileState = 0    
                                else:   
                                    TttileState += 1
                                    if TttileState == 1:
                                        Draw.textInfo(posX,posY,0,'Stop',0,font,font14,canvas)                              
                                    else:
                                        Draw.textInfo(posX,posY,0,'Run',0,font,font14,canvas)
                                        SigDeparture(False)
                                        TttileState = 0

                        elif e.Mul == 3:    # Zuglenkung
                            if Ttactive:
                                print('Ttactive, ZL rejected')
                            else:
                                Draw.rect(canvas,LGRAY,[(posX*elx+offsx+1,posY*ely+offsy+1),(60,40)])
                                Draw.textInfo(Gray3[0],Gray3[1],0,'ZL',1,font,font14,canvas)
                                if zname != '':                                                          
                                    if ZLactive:
                                        ZLactive = False
                                        Draw.text(canvas,BLACK,(posX*elx+offsx+elx/2,posY*ely+offsy+ely/2),font,'Off',True)                                    
                                        ZLqueue.queue.clear() # Fweg/Fstr entfernen aus Queue
                                        print("ZL off")
                                    else:
                                        ZLactive = True                                         
                                        Draw.textInfo(posX,posY,0,'ZL on',0,font,font14,canvas)
                                        print("ZL on")
                                        SigDeparture(True)
                                    Draw.textInfo(posX,posY,0,zname[0:9],2,font,font14,canvas)
                                    
                                else:
                                    Draw.textInfo(posX,posY,0,"no File",2,font,font14,canvas)    
            #-----------------------------------------------------           
                        
                elif sel == 'S':
                    #e = Stp[posY][posX]
                    
                    if Signal_ZR == 'Zugf':
                        if e.inFstr or e.FstrStart:
                            if e.ST in [30,31]:
                                if e.Shstate == 'Sh1':
                                    SigChkR(posX,posY)
                                else:
                                    print('Sh1 in Fahrstraße nicht stellbar')

                            else:    #Hauptsignal oder HpSh
                                if e.Hpstate == 'Hp0':
                                    print('Signalfahrt in Fahrstraße nicht stellbar')
                                else:                                
                                    SigChkF(posX,posY)
                                    LokTraceStop(e,posX,posY,True)
                        else:
                            if RouteClass == 0:
                                SigChkF(posX,posY)    
                        
                    else:            #Rangierfahrt
                        if e.inFstr or e.FstrStart:
                            if e.Shstate == 'Sh0':
                                print('Signalfahrt in Fahrstraße nicht stellbar')
                            else:
                                SigChkR(posX,posY)
                        else:
                            if RouteClass == 0:
                                SigChkR(posX,posY)
                                
            #-----------------------------------------------------                 
                        
                elif sel == 'K':                    
                    KeySwitch(posX,posY)

                elif sel == 'b':
                    FwegSwitch(posX,posY)

#--------------------------------------------------------

    elif event.num==3:     # Mouse Taste rechts
        if DebugFs: print('Mousekey right call Route')
        EL=Stp[posY][posX]
        if EL.Sel == 'W':
            print('Weiche, WState: ',EL.WState)
        elif EL.Sel == 'S':    
            if RouteClass > int(0):            
                if RelbyTrain and Stp[posY][posX].FstrStart:
                    print('Fahrstraßenauflösung nur durch Zug')
                else:
                    if Stp[posY][posX].FstrStart:
                        print('Fahrstraßenauflösung durch Bedienhandlung')
                    Erfolg, ZielSig, Loknummer = route.Routing(posX,posY,Stp,Rm,canvas,Signal_ZR,SigChkF,SigChkR,GrauFeld,0,LokTraceStop)
                    if Erfolg:
                        ZLsuch_putQ(ZLtab,ZielSig,Loknummer)
                                           

                    #0: Auflösen per Hand auch mit ZL zulassen
            else:
                print('Play Mode, keine Fahrstrassen')

        else:
            print('kein Signal')
            
        
#--------------------------------------------------------
    elif event.num==2:     # Mouse Taste mitte
        global cmd
        global mstr
        
        if MoveState == 0:
            px1 = int(posX)              
            py1 = int(posY)            

            print('GrauFeld: ',GrauFeld)            

            e = Stp[py1][px1]
            print("p1:",px1,py1)
            if e.Sel == '':
                print("- leer -", e.Ele)
            
            else:
                if e.Sel == 'S':
                    if GrauFeld >= 2:                        
                        Lokadresse(e)
                        print('e.Lokstp,cmd,mstr:',e.LokStop,cmd,mstr)                        

                        if e.Rm != 0 and cmd in ['trg','stp','sta','dir','hor']:
                            pass                            
                        else:
                            print('Kein Belegtmelder bzw. kein num. Wert')
                            
                    else:
                        print('Signal,Rm,LokStop',e.N,e.Rm,e.LokStop)
                        print('inFstr,FstrStart,FstrEnde',e.inFstr,e.FstrStart,e.FstrEnde)
                        print('Hpstate,Shstate,ZR',e.Hpstate,e.Shstate,e.FstrZR)
    else:
        print('mkey',event.num)

#--------------------------------------------------------

def SigDeparture(boolvar):
    global SignalDep
    global Red1
    
    Draw.rect(canvas,RED,[(Red1[0]*elx+offsx+1,Red1[1]*ely+offsy+1),(60,40)])
    Draw.textInfo(Red1[0],Red1[1],0,'Departure',1,font,font14,canvas)
    if boolvar:
        SignalDep = True
        Draw.text(canvas,WHITE,(Red1[0]*elx+offsx+elx/2,Red1[1]*ely+offsy+5+ely/2),font14,'On',True)
 
    else:        
        SignalDep = False
        Draw.text(canvas,BLACK,(Red1[0]*elx+offsx+elx/2,Red1[1]*ely+offsy+5+ely/2),font14,'Off',True)
        qLokHp1.queue.clear() # alle Loks entfernen aus Queue


def ZLsuch_putQ(ZLtab,ZielSig,Loknummer):
    global ZLactive
    if ZLactive:
        for i in range(len(ZLtab)):            
            if ZLtab[i][0] == ZielSig and ZLtab[i][1] == Loknummer:
                lenZL = len(ZLtab[i])
                if lenZL == 4:
                    ZLqueue.put(ZLtab[i][2])                            
                    ZLqueue.put(ZLtab[i][3])    
                    ZLqueue.put(ZielSig)
                    print('to ZLqueue:',ZLtab[i][2],ZLtab[i][3],ZielSig)
                elif lenZL == 3:
                    ZLqueue.put(ZLtab[i][2])                            
                    ZLqueue.put('')    
                    ZLqueue.put(ZielSig)
                    print('to ZLqueue:',ZLtab[i][2],'',ZielSig)


def ZLsuchHf_putQ(ZLtab,HfSignal):
    global ZLactive
    global Bskip
    if ZLactive:
        print("Suche:",HfSignal)
        for i in range(len(ZLtab)):
            hf = ZLtab[i][0]
            if hf[0] == '-':                
                hf = hf.lstrip('-')
                if hf == HfSignal:
                    lenZL = len(ZLtab[i])
                    if lenZL == 3:
                        xs,ys = findoneHpSig(ZLtab[i][2])
                    elif lenZL == 4:
                        xs,ys = findoneHpSig(ZLtab[i][3])
                    if [xs,ys] != [0,0]:
                        print("Haltfallsignal:",hf,"Zug",ZLtab[i][1],"Fweg",ZLtab[i][2],"Sig @",xs,ys)
                        sp = Stp[ys][xs]
                        Locnr = sp.LokStop
                        Rmnr  = sp.Rm
                        Signeu= sp.N
                        print("Fahrstraßenende:",sp.FstrEnde)
                        if Locnr == 0 or Locnr == '':
                            print("keine Identifizierung")
                        else:
                            if Rm[Rmnr][2] or Bskip:
                                print("Signal",Signeu," ist belegt mit",Locnr)
                            
                                print("ID",Locnr,"akzeptiert")
                                if lenZL == 3:                                
                                    ZLqueue.put(ZLtab[i][1])
                                    ZLqueue.put('')
                                    ZLqueue.put(ZLtab[i][2]) 
                                elif lenZL == 4:                                
                                    ZLqueue.put(ZLtab[i][1])
                                    ZLqueue.put(ZLtab[i][2])
                                    ZLqueue.put(ZLtab[i][3])    

                            else:   #Abschniitt frei keine Fstr,kein Lokstart
                                print("Signal",Signeu," nicht belegt")                               
                            
                    break
            

def TCtrigger(tsig):
    global GrauFeld       #Auswahl im Optionsfeld (hier nicht relevant, Rangierwendefahrt)
    global RouteClass
    global Ttactive
    Erfolg    = False
    ZielSig   = ''
    Loknummer = 0

    if RouteClass > int(0):   
        sig = tsig
        sko = findoneHpSig(sig)
        print('Signal',sig,'at',sko)  
        
        Erfolg,ZielSig,Loknummer = route.Routing(sko[0],sko[1],Stp,Rm,canvas,Signal_ZR,SigChkF,SigChkR,GrauFeld,Ttactive,LokTraceStop)
        if Erfolg == True:
            print('routing erfolgreich,ZielSig:',ZielSig)
            ZLsuch_putQ(ZLtab,ZielSig,Loknummer)
        else:
            print('Routing-Error, Abbruch ZL/Tt')
            if Ttactive:
                Ttresume()      # Resume nur bei Tt
            
    return Erfolg
    

def TCtriggerfw(fwb):    
    if fwb == '':               #from ZLqueue possible
        return False
    elif fwb == '*':
        print('kein Fweg')
        return True
    fko,io = findoneFweg(fwb)
    print('Fwegbutton',fwb,'at',fko, io)
    return io


def TCjump(mins,secs):
    print('Suche nach min, sec:',mins,secs)
    found = False
    for i in range (len(Ttab)):
        if mins == Ttab[i][0] and secs == Ttab[i][1]:
            found = True
            print('Suche:',found,'at',i)
            return i,found

    print('time not found:',found, 'imax:',i)    
    return i,found


def TCnext(mins,secs):
    Timersuch = int(mins) * 60 + int(secs)
    found = False
    for i in range (len(Ttab)):
        Timerintab = int(str(Ttab[i][0])) * 60 + int(str(Ttab[i][1]))
        if Timerintab >= Timersuch:
            found = True
            print("next i, min,sec:",i,Ttab[i][0],Ttab[i][1],Ttab[i])            
            return i,found
        
    print('timenext not found:',found, 'imax:',i)    
    return i,found


def TimerAfter():
    global TimerA
    global Gray1
    global Gray2
    global TCtile
    global Tttile
    global Ttab
    global Ttindex
    global TttileState
    global Ttloopcnt
    global qLokHp1
    global LokHp1delay
    global ZLqueue
    global WendeSkip

    if ZLqueue.empty() == False:
        errcnt = 0
        val = ZLqueue.get()
        print('1from ZLqueue:',val)     #1.Fweg
        if not TCtriggerfw(val):
            errcnt += 1            
        val = ZLqueue.get()        
        print('2from ZLqueue:',val)     #2.Fweg
        if val != "":           
            if not TCtriggerfw(val):
                errcnt += 2           
        if errcnt == 0:                 #possible
            TCtrigger(ZLqueue.get())    #Signal
        else:
            ZLqueue.get()               #keine Fstr.
        print("ZLqueue errcnt -----------",errcnt)

    if LokHp1delay > 0:
        LokHp1delay -= 1
        if LokHp1delay == 0:
            if qLokHp1.empty() == False:
                LokfromQ = qLokHp1.get()
                print('LQue:',LokfromQ)

                vredu = Vvalue(LokfromQ,3)                
                SerialIO.SendLokBypass(0, LokfromQ, vredu)
                updateSignalWidgetSpeed(LokfromQ, vredu)
                setVist(LokfromQ, vredu)
                
    else:
        if qLokHp1.qsize() > 0:
            LokHp1delay = 3
        
    #--------- Timer ------------------------------------------------------

    if TCtile and TttileState == 0:
    
        TimerA += 2

        sec     = int(TimerA % 60)
        minutes = TimerA     // 60
        hours   = int(TimerA // 3600)

        th = hours
        
        mi = int(minutes)
        mi = mi % 60
        mi = str(mi)
        
        mi = mi.zfill(2)
        
        ts = str(sec)
        ts = ts.zfill(2)

        tim = str(th)+':'+str(mi)+':'+ts
        Tpx = Gray1[0]
        Tpy = Gray1[1]
        Draw.rect(canvas,LGRAY,[(Tpx*elx+offsx+1,Tpy*ely+offsy+1),(elx-1,14)])                                                      
        Draw.text(canvas,BLACK,(Tpx*elx+offsx+30,Tpy*ely+offsy+8),font,tim,True)

    if TCtile and RouteClass > int(0) and TttileState == 0:  #Kachel grau Op.1 vorhanden
        
        Tpx = Gray2[0]
        Tpy = Gray2[1]
        Draw.rect(canvas,LGRAY,[(Tpx*elx+offsx+1,Tpy*ely+offsy+1),(elx-1,14)])                                                      
        Draw.text(canvas,BLACK,(Tpx*elx+offsx+30,Tpy*ely+offsy+8),font,Ttindex,True)
        Draw.rect(canvas,LGRAY,[(Tpx*elx+offsx+1,Tpy*ely+offsy+27),(elx-1,14)])  
        Draw.textInfo(Tpx,Tpy,0,str(Ttloopcnt),2,font,font14,canvas)
    
        if Ttactive:            
            if int(str(Ttab[Ttindex][0])) == int(mi) and int(str(Ttab[Ttindex][1])) == int(ts):
                print('trigger')
                Ttziff = int(str(Ttab[Ttindex][2]))
                if Ttziff == 7:        #Search & jump
                    mins = Ttab[Ttindex][3]
                    secs = Ttab[Ttindex][4]
                    i,found = TCnext(mins,secs)
                    if found:                        
                        print('Goal:',Ttab[i])
                        #Timerset = int(mins) * 60 + int(secs)
                        Timerset = int(str(mins)) * 60 + int(str(secs))
                        print('min,sec:',mins,':',secs,Timerset)
                        print('jump to:')
                        Ttindex = i;
                        TimerA = Timerset
                        Ttziff = int(str(Ttab[Ttindex][2]))
                    
                
                if Ttziff in [1,2,3,4]:
                    print('Timer, Ttz:',ts,Ttziff)
                    Timetableziffer(Ttziff,Ttab[Ttindex][4]) #Signal, keine Fstr
                    if Ttziff == 3: WendeSkip = True
                    
                elif Ttziff == 5:         #Signal        ,  Lokadresse
                    TimetabNewLok(Ttziff,Ttab[Ttindex][3],Ttab[Ttindex][4])
                     
                else:                
                    Fweg = Ttab[Ttindex][3]
                    print('Fahrweg:',Fweg)                    
                    if Fweg != '':                    
                        if TCtriggerfw(Fweg):
                            print('Fahrweg eingestellt')
                        else:
                            print('Fahrweg nicht einstellbar')
                            Ttresume()
                            root.after(2000,TimerAfter)
                            return

                    Fstr = Ttab[Ttindex][4]
                    if Fstr != '':
                        if TCtrigger(Fstr):
                            print('Fahrstraße eingestellt')
                        else:
                            print('Fahrstraße nicht einstellbar')
                            Ttresume()
                            root.after(2000,TimerAfter)
                            return
                                              
                Ttindex += 1
                print('Ttindex nach Erhöhung,len(Ttab):',Ttindex,len(Ttab))
                if Ttindex >= len(Ttab):
                    Ttloopcnt += 1
                    Ttindex    = 0
                    TimerA     = 0          # repeat
                print('Next,Ttindex:',Ttab[Ttindex],Ttindex)

    timer_id = root.after(2000,TimerAfter)

#--------------------------------------------------------

def Ttstateoff():       #Timetable aus
    global Ttactive
    global Tttile
    global Ttindex
    global Ttfile
    if Ttactive:
        Ttactive = False
        print('Timetable off')
        Draw.rect(canvas,LGRAY,[(Gray1[0]*elx+offsx+1,Gray1[1]*ely+offsy+1),(60,40)])
        if Ttfile != "":
            fname = ntpath.basename(Ttfile)         
            Draw.textInfo(Gray1[0],Gray1[1],0,fname[0:9],2,font,font14,canvas)
        
        if Tttile:
            Ttindex = 0
            Draw.rect(canvas,LGRAY,[(Gray2[0]*elx+offsx+1,Gray2[1]*ely+offsy+1),(60,40)])
            

def Ttresume():         # Timetable anhalten
    global Tttile
    global TttileState
    global Gray2

    Tpx = Gray2[0]
    Tpy = Gray2[1]
    if Tttile:
        TttileState = 2
        Draw.textInfo(Tpx,Tpy,0,'Resume',0,font,font14,canvas)
       
    
def Timetableziffer(Ttz,Signal):
    global WendeSkip
    
    sko = findoneHpSig(Signal)
    print('sko:',sko)
    if sko != [0,0]:
        print('Signal, at:',Signal,sko)
        e = Stp[sko[1]][sko[0]]
        print('Lok:',e.LokStop)

        if Ttz == 1:                    # StartOnClick            
            if str(e.LokStop).isnumeric():
                if WendeSkip:           
                    speed = Vvalue(e.LokStop,3)
                    SerialIO.SendLokStart(e.Rm, e.LokStop, speed)
                    updateSignalWidgetSpeed(e.LokStop, speed)
                    Wendeskip = False
                else:
                    if e.FstrStart and e.Hpstate == "Hp1":                
                        speed = Vvalue(e.LokStop,3)
                        SerialIO.SendLokStart(e.Rm, e.LokStop, speed)
                        updateSignalWidgetSpeed(e.LokStop, speed)
                        setVist(e.LokStop, speed)
                    else:
                        print("keine Fstr. oder Hp0")
                        Ttresume()

        elif Ttz == 2:                  # StopOnClick
            if str(e.LokStop).isnumeric():
                SerialIO.SendLokStop(e.Rm, e.LokStop)
                updateSignalWidgetSpeed(e.LokStop, 0)
                setVist(e.LokStop, 0)

        elif Ttz == 3:                  # DirOnClick
            if str(e.LokStop).isnumeric():
                SerialIO.SendLokDir(e.Rm, e.LokStop)
                showLok(e)   #Stopp reaktivieren
                updateSignalWidgetSpeed(e.LokStop, 0)
                setVist(e.LokStop, 0)
                
            
        elif Ttz == 4:                  # HornOnClick
            if str(e.LokStop).isnumeric():
                func = Fvalue(e.LokStop,2)
                SerialIO.SendLokHorn(e.Rm, e.LokStop, func)      
                
    else:
        print('Signal',Signal,'nicht gefunden')
        
        

def TimetabNewLok(Ttziff,Signal,NewLok):
    if DebugTf: print('Tt neue Lok,Sig,Lok:',Signal,NewLok)
    sko = findoneHpSig(Signal)
    if DebugTf: print('sko:',sko)
    if sko != [0,0]:
        if DebugTf: print('Signal, at:',Signal,sko)
        e = Stp[sko[1]][sko[0]]        
        e.LokStop = NewLok
        e.Stopmsg = True
        showLok(e)        
        updateSignalWidgetLoco(Signal)

#--------------------------------------------------------
# call from Routexx


def LokTraceStop(e,x,y,StopOn): # Graufeld erforderlich (quelle: 2176 def showLok() )
    if DebugFs: print('loktraceStop at x,y:', x,y)
    if StopOn:
        e.Stopmsg = True
        if e.Rm != 0:
            if e.ST in [27,29,31]:  #Loktext unten
                Draw.rect(canvas,TABLE,[(x*elx+offsx+1,y*ely+offsy+1+25),(elx-1,14)])
                if e.LokStop != 0:                                        
                    Draw.text(canvas,OKER,(x*elx+offsx+30,y*ely+offsy+33),font,e.LokStop,True)
            else:                   #loktext oben
                Draw.rect(canvas,TABLE,[(x*elx+offsx+1,y*ely+offsy+1),(elx-1,14)])
                if e.LokStop != 0:                                        
                    Draw.text(canvas,OKER,(x*elx+offsx+30,y*ely+offsy+8),font,e.LokStop,True)                                
            
            SerialIO.SendSigStop(e.Rm,e.LokStop,GrauFeld) #Auftrag an Arduino

            updateSignalWidgetLoco(e.N)

    else:
        if str(e.LokStop).isnumeric():
            SerialIO.SendStopvoid(e.Rm,e.LokStop)            
                
            if e.Sel == 'S':
                if e.LokStop != 0:
                    e.Stopmsg = False
                    if e.ST in [27,29,31]:  #Loktext unten
                        Draw.rect(canvas,TABLE,[(x*elx+offsx+1,y*ely+offsy+1+25),(elx-1,14)])
                        Draw.text(canvas,WHITE,(x*elx+offsx+30,y*ely+offsy+33),font,e.LokStop,True)
                    else:
                        Draw.rect(canvas,TABLE,[(x*elx+offsx+1,y*ely+offsy+1),(elx-1,14)])
                        Draw.text(canvas,WHITE,(x*elx+offsx+30,y*ely+offsy+8),font,e.LokStop,True)

                updateSignalWidgetLoco(e.N)


def updateSignalWidgetLoco(Sig):
    for window in root.winfo_children():
        if isinstance(window, tk.Toplevel) and hasattr(window, 'update_loco'):
            window.update_loco(Sig)

def updateSignalWidgetSpeed(Loco, Speed):
    for window in root.winfo_children():
        if isinstance(window, tk.Toplevel) and hasattr(window, 'update_speed'):
            window.update_speed(Loco, Speed)
            
def updateSignalWidgetSig(Sig):
    ex = False
    for window in root.winfo_children():
        if isinstance(window, tk.Toplevel) and hasattr(window, 'check_Widexist'):
            if window.check_Widexist(Sig):
                ex = True
    return ex
    
#--------------------------------------------------------

def showLok(e):
    sko = findoneHpSig(e.N)
    if DebugTf: print('findoneHpSig()',e.N,sko)
    if e.Rm != 0:
        if e.ST in [27,29,31]:  #Loktext unten
            Draw.rect(canvas,TABLE,[(sko[0]*elx+offsx+1,sko[1]*ely+offsy+1+25),(elx-1,14)])
            if e.LokStop != 0:                                        
                Draw.text(canvas,OKER,(sko[0]*elx+offsx+30,sko[1]*ely+offsy+33),font,e.LokStop,True)
        else:                   #loktext oben
            Draw.rect(canvas,TABLE,[(sko[0]*elx+offsx+1,sko[1]*ely+offsy+1),(elx-1,14)])
            if e.LokStop != 0:                                        
                Draw.text(canvas,OKER,(sko[0]*elx+offsx+30,sko[1]*ely+offsy+8),font,e.LokStop,True)                                
        
        SerialIO.SendSigStop(e.Rm,e.LokStop,GrauFeld)   #Auftrag an Arduino
        
        func = Fvalue(e.LokStop,0)                      #Licht vorn
        SerialIO.SendLokFunc(e.Rm, e.LokStop, func)     #F0
        func = Fvalue(e.LokStop,1)
        if DebugFV:
            if func == '':
                print("Lokparameter 1 leer")
            else:
                print("Lokparameter 1:",func)
        SerialIO.SendLokFunc(e.Rm, e.LokStop, func)     #F1
        

def showInfo(e):
    global mstr
    sko = findoneHpSig(e.N)
    px1 = sko[0]
    py1 = sko[1]
    mstr = mstr[0:10]
    if e.ST in [27,29,31]:  #Merker unten
        Draw.rect(canvas,TABLE,[(px1*elx+offsx+1,py1*ely+offsy+1+25),(elx-1,14)])                                                                           
        Draw.text(canvas,WHITE,(px1*elx+offsx+30,py1*ely+offsy+33),font,mstr,True)
    else:                   #Merker oben
        Draw.rect(canvas,TABLE,[(px1*elx+offsx+1,py1*ely+offsy+1),(elx-1,14)])                                                                           
        Draw.text(canvas,WHITE,(px1*elx+offsx+30,py1*ely+offsy+8),font,mstr,True)  
    

        
def Lokadresse(e):
    print('Signal,Rm',e.N,e.Rm,'at',px1,py1)
    global mstr
    global cmd
    
    

    def OkOnClick():
        global mstr
        global cmd        
        mstr = ''
        la = etEingabe.get()
        if la.isnumeric():
            e.LokStop = la
            cmd = 'trg'
            showLok(e)
            e.Stopmsg = True    #Meldung an Lokfenster
            print('Eingabe fenster:', la)
        else:
            mstr = la
            e.LokStop = mstr
            cmd = 'inf'
            showInfo(e)
            close_window(fenster)
        
        
    def CancelOnClick():        
        print('new Button Void')
        if str(e.LokStop).isnumeric():
            SerialIO.SendStopvoid(e.Rm,e.LokStop)                       
                     
            x = Rm[e.Rm][0] #1-16 (Rm array 0-15)
            y = Rm[e.Rm][1]
            
            if e.Sel == 'S':
                if e.LokStop != 0:
                    e.Stopmsg = False
                    if e.ST in [27,29,31]:  #Loktext unten                                       
                        Draw.text(canvas,WHITE,(x*elx+offsx+30,y*ely+offsy+33),font,e.LokStop,True)
                    else:
                        Draw.text(canvas,WHITE,(x*elx+offsx+30,y*ely+offsy+8),font,e.LokStop,True)
                

     # Funktion zum Schließen eines Fensters
    def close_window(window):
        window.destroy()
        
    def StartOnClick():
        global cmd        
        locked.set(False)
        print("Button Start",e.LokStop)
        speed = Vvalue(e.LokStop,5)        
        cmd = 'sta'
        wert.set(speed)
        e.Stopmsg = True
        if str(e.LokStop).isnumeric():
            SerialIO.SendLokStart(e.Rm, e.LokStop, speed)
            updateSignalWidgetSpeed(e.LokStop, speed)
            setVist(e.LokStop, speed)

    def StopOnClick():
        global cmd        
        locked.set(True)
        print("Button Stop",e.LokStop)
        cmd = 'stp'
        wert.set(0)
        if str(e.LokStop).isnumeric():
            SerialIO.SendLokStop(e.Rm, e.LokStop)
            updateSignalWidgetSpeed(e.LokStop, 0)
            setVist(e.LokStop, 0)

    def DirOnClick():
        global cmd        
        print("Button Direction")
        cmd = 'dir'
        wert.set(0)
        if str(e.LokStop).isnumeric():
            SerialIO.SendLokDir(e.Rm, e.LokStop)
            updateSignalWidgetSpeed(e.LokStop, 0)
            setVist(e.LokStop, 0)

    def HornOnClick():
        global cmd        
        print("Button Horn")
        cmd = 'hor'        
        if str(e.LokStop).isnumeric():
            func = Fvalue(e.LokStop,2)        # 2: code Horn
            print()
            print('LOK,Hornfunktion:',e.LokStop,func)
            SerialIO.SendLokHorn(e.Rm, e.LokStop, func)

    def update_loco(Sig): # public
        if Sig==e.N:
            print('update_loco')
            etEingabe.delete(0, END)
            etEingabe.insert(0, e.LokStop)

    def update_speed(Loco, Speed): # public
        if str(Loco)==str(e.LokStop):
            print('update_speed')
            wert.set(Speed)
            
    def check_Widexist(Sig):       #public
        print('Sig:,Sig,e.N:',Sig,e.N)
        wexist = False
        if Sig == e.N:                      
            wexist = True        
        return wexist

    def aktion(self):        
        if locked.get():
            pass
        else:
            lbWert["text"] = f"Aktion: {scWert.get()} km/h"
            speed = scWert.get()
            print("Speed:",speed)
            if str(e.LokStop).isnumeric():
                SerialIO.SendLokSpeed(e.Rm, speed)
                updateSignalWidgetSpeed(e.LokStop, speed)
                setVist(e.LokStop, speed)


#-------------------------------------------------
    # Fenster nochmal öffnen verhindern
    if updateSignalWidgetSig(e.N):
        print('Widget für Signal:', e.N, 'bereits vorhanden')
        return                

    # zu viele Fenster verhindern
    signalWidgetCount = 0
    for window in root.winfo_children():
        if isinstance(window, tk.Toplevel) and hasattr(window, 'update_loco'):
            signalWidgetCount += 1
            if signalWidgetCount >= 4:        
                print("nur 4 neue Fenster erlaubt")
                mstr = ''
                cmd  = ''
                return
        
    fenster = tk.Toplevel(root)    
   
    fenster.protocol("WM_DELETE_WINDOW", lambda: close_window(fenster))

    wert = tk.IntVar()
    wert.set(0)

    locked = tk.IntVar()
    locked.set(True)
    
    #widget_id = fenster.winfo_id()
    #print("Widget ID is:", widget_id)
    
    ofsx = signalWidgetCount * 20
    ofsy = signalWidgetCount * 20    
    fenster.wm_geometry(f'340x200+{int(ofsx)}+{int(ofsy)}')    
    fenster.title('Signal ' + e.N)
    fenster.resizable(0, 0)   

    # drei Methoden öffentlich machen
    fenster.update_loco    = update_loco
    fenster.update_speed   = update_speed
    fenster.check_Widexist = check_Widexist    

    scWert = tk.Scale(fenster, length=300, orient= "horizontal",
                from_=0, to=100, resolution=5, tickinterval=20, label="km/h",
                command=aktion, variable=wert)
    scWert.place(x=10,y=10)    

    lbWert = tk.Label(fenster, text="Start: 0 km/h")

    etEingabe = tk.Entry(fenster)
    etEingabe.place(x=23,y=100)
    etEingabe.insert(END, e.LokStop)
    
    lbEingabe = tk.Label(fenster,text="Signal "+e.N+" Rm "+str(e.Rm))
    lbEingabe.place(x=150,y=100)
        
    photo = PhotoImage(file="horn 30x16.png")
    buHorn = tk.Button(fenster, image=photo, text=" ", compound="center",
                       command=HornOnClick, width=60)
    buHorn.Tag = photo
    buHorn.place(x=10,y=130)
    
    photo2 = PhotoImage(file="Start42x16.png")
    buStart = tk.Button(fenster, image=photo2, text=" ", compound="center",
                        command=StartOnClick, width=60)
    buStart.Tag = photo2
    buStart.place(x=95,y=130)
    
    buStop = tk.Button(fenster, text="LokStop", command=StopOnClick, width=8)
    buStop.place(x=180,y=130)
    
    buDirection = tk.Button(fenster, text="< >", command=DirOnClick, width=8)
    buDirection.place(x=10,y=165)             

    photo5 = PhotoImage(file="Sh7void11x16.png")
    buEnde = tk.Button(fenster, image=photo5, text=" ", compound="center",
                       command=CancelOnClick, width=60)
    buEnde.Tag = photo5
    buEnde.place(x=95,y=165)                  
    
    photo3 = PhotoImage(file="Sh7_12x16.png")
    buHalt = tk.Button(fenster, image=photo3, text=" ", compound="center",
                        command=OkOnClick, width=60)
    buHalt.Tag = photo3
    buHalt.place(x=180,y=165)

    showLok(e)    
         
    Vist = getVist(e.LokStop)
    if int(Vist) >= 0:
        print('Lok, V:',int(e.LokStop), Vist)        
        updateSignalWidgetSpeed(e.LokStop, int(Vist))
    else:
        print('lok not in List')          

    fenster.bind("<Escape>", lambda x: fenster.destroy())    
    fenster.transient(root)  # dialog window is related to main

        
    
#--------------------------------------------------------

def loadlastfile():
    global lastpath
    global pfad
    
    IOerr = False
    try:
        print('trylastpathopen:',lastpath)
        fh = open(lastpath, encoding='utf-8')
    except:
        IOerr = True
        print("Abbruch open file")

    if not IOerr:
        clearAll()

        fname = ntpath.basename(lastpath)
        showFilename(canvas, fname)
        print("Datei geöffnet:",fname)

        elearr,cnt = RDstr.RDcsv(fh)
        fh.close()

        pfad = lastpath

        print("Zeilen:",cnt)

        Fweg = RDstr.getFweg()
        print('Anzahl Fwege: ', len(Fweg))

        csv2pic(canvas, elearr, cnt, Fweg)
        LinkSearch()

        

def LinkSearch():
    BA = [[' ',-1,-1,] for i in range (20)]
    bi = 0
    for y in range(ElanzY):
        for x in range(ElanzX):                
            e = Stp[y][x]                
            if e.Sel == 't':
                txt = e.N
                p = txt.find(':')
                if p >= 0:
                    c = txt[p+1]
                    #print('LinkSelektor:',c)
                    
                    if c >= 'A' and c <= 'Z':
                        BA[bi][0] = c
                        BA[bi][1] = x
                        BA[bi][2] = y
                        #print('BuddyArray:',BA[bi])
                        bi += 1

                    else:    
                        txt = txt[1:]
                        t_split=txt.split(',')
                        ax = t_split[0]
                        ay = t_split[1]
                        e.BuddyX = ax
                        e.BuddyY = ay
                        #print('Link at hier:',x,y,ax,ay)
                        
    print('bi Einträge:',bi)
    #for i in range (bi):
        #print('BuddyArray :',i, BA[i])

    
    for i in range (bi):    #Buddy-Suche:
        Ba = BA[i][0]
        j=i+1
        for j in range (bi):
            if BA[j][0] == Ba:
                if j != i:
                    #print('Buddyindex:',j,i)
                    qx = BA[j][1]
                    qy = BA[j][2]
                    ix = BA[i][1]
                    iy = BA[i][2]
                    #print('Quelle, Zieindex x,y:',qx,qy,ix,iy)
                    z  = Stp[iy][ix]                    
                    z.BuddyX = qx
                    z.BuddyY = qy
                    #print('Ziel Ele,Name.Buddy x,y',z.Ele,z.N,z.BuddyX,z.BuddyY)
                                        
#----------------------------------------------------

def bitnumber(i,li):
    global Rm
    global GrauFeld
    
    change = i ^ li
    #print('XOR RM',"0x%04X" % change)
    
    msk = 1
    for k in range(0,33):
        bit = change & msk       #Änderungen?
        if bit != 0:            
            rbit = k+1           #1-32(array 0-31)
            x = Rm[rbit][0]
            y = Rm[rbit][1]
            e = Stp[y][x]
            if e.Sel == 'S': 
                Fstr = e.inFstr | e.FstrStart | e.FstrEnde
                #print('signal, Fahrstraße,Belegt',e.N,Fstr,Rm[rbit][2])
            elif e.Sel == 't':
                Fstr = e.inFstr
                    
            
            if x != 0 and y != 0:
                state = i & msk            
                if state != 0:                      # Belegung
                    Rm[rbit][2] = True
                    Draw.trackl(x,y,RED,canvas)
                    if e.Sel == 'S':                # Belegtmelder ohne Signal
                        if hasattr(e,'Vhalbexy'):
                            if e.Vhalbexy != [0,0]:
                                # Prüfung Folgesignal
                                print('Vhalbe check, >>>>>> Zielsig ist auf:',e.Vhalbexy,'Lok:',e.LokStop)
                                ez = Stp[e.Vhalbexy[1]][e.Vhalbexy[0]]
                                print('Ziel Signal:',ez.Hpstate)
                                if ez.Hpstate == 'Hp0':
                                    e.Vhalbexy = [0,0]

                                    vredu = Vvalue(e.LokStop,2)
                                    SerialIO.SendLokBypass(e.Rm, e.LokStop, vredu)
                                    updateSignalWidgetSpeed(e.LokStop, vredu)                            
                                    setVist(e.LokStop, vredu)

                            if e.LokStop != 0 and e.Stopmsg:                    # Wenn Stopfunktion aktiv                        
                                updateSignalWidgetSpeed(e.LokStop, 0)
                                # Stoppt vorher über diese Nachricht
                            
                            if RouteClass > 1:
                                if e.Sel == 'S':
                                    #print('Auflösung ab x,y:',e.Zr)
                                    route.RouteLocking(e.Zr[0],e.Zr[1],Stp,Rm,canvas,Signal_ZR,SigChkF,SigChkR,GrauFeld,0,LokTraceStop)
                                                    #0:Aufl. bei Timetable
                                    e.Zr = [0,0]
                #-----------------------------------------------------------------
                else:                       # Freimeldung
                    Rm[rbit][2] = False
                    if Fstr:
                        if e.FstrEnde: 
                            if e.FstrEndZR == 'Zugf':
                                Draw.trackl(x,y,YELLOW,canvas)
                            else:
                                Draw.trackl(x,y,BLUE,canvas)
                        else: 
                            if e.FstrZR == 'Zugf':
                                Draw.trackl(x,y,YELLOW,canvas)
                            else:
                                Draw.trackl(x,y,BLUE,canvas)
                    else:
                        Draw.trackl(x,y,GRAY,canvas)

                    
                    if e.Sel == 'S':
                        if e.Hpstate == 'Hp1':
                            SigChkF(x,y)
                        if e.Shstate == 'Sh1':
                            SigChkR(x,y)

                #-----------------------------------------------------------------        
                
        msk = msk << 1

#--------------------------------------------------------
        
def SigChkF(posX,posY):
    global ZLtab        # Zuglentabelle Haltfall
    global qLokHp1      # Queue
    global SignalDep    # True: Lokstart erlaubt
    
    e = Stp[posY][posX]        
    if DebugFs:
        print('CheckF')
        print('Styp, StateHp, StateSh',e.ST,e.Hpstate,e.Shstate)
        print('Zeiger:',e.Zv[1],e.Zr[0])

    if e.N[0] == '*':
        print('Signal mit * immer Hp0')
        return

    Sad = e.DA

    if e.Hpstate == 'Hp0':
        e.Shstate = 'Sh1'
        e.Hpstate = 'Hp1'
    else:
        e.Shstate = 'Sh0'
        e.Hpstate = 'Hp0'
        print("----------Haltfall Signal:",e.N)
        ZLsuchHf_putQ(ZLtab,e.N)

    if e.Shstate == 'Sh0':
        Sad = -Sad

    if e.ST in range (26,28):                    # Hp mit Sh
        if Sad != 0:
            if e.Shstate == 'Sh1':               # Fahrt
                SerialIO.Wswitch(Sad,0)              # Hp

                if Sad < 0:
                    SerialIO.Wswitch(-(abs(Sad)+1),0) # Sh
                else:
                    SerialIO.Wswitch(Sad+1,0)

            else:                   # Halt (Schaltreihenfolge tausch)
                if Sad < 0:
                    if Sad < 0:
                        SerialIO.Wswitch(-(abs(Sad)+1),0)  # Sh
                    else:
                        SerialIO.Wswitch(Sad+1,0)
                    SerialIO.Wswitch(Sad,0)                # Hp

        Draw.ShHaspect(posX,posY,e.ST,e.Shstate,canvas)
        Draw.HpAspect(posX,posY,e.ST,e.Hpstate,canvas)
        
        if e.Hpstate == 'Hp1':
            if SignalDep:       # Lokstart erlaubt
                if str(e.LokStop).isnumeric():
                    toQue = int(e.LokStop)
                    if toQue > 0:
                        qLokHp1.put(toQue)
                        speed = Vvalue(e.LokStop,5)
                        updateSignalWidgetSpeed(e.LokStop, speed) #speed wie getQueue
                        setVist(e.LokStop, speed)
                else:
                    print('nicht num. kein Lokstart')

    elif e.ST in range (28,30):         # Hp allein
        if Sad != 0:
            SerialIO.Wswitch(Sad,0)
        Draw.HpAspect(posX,posY,e.ST,e.Hpstate,canvas)

        if e.Hpstate == 'Hp1':
            if SignalDep:       # Lokstart erlaubt
                if str(e.LokStop).isnumeric():
                    toQue = int(e.LokStop)
                    if toQue > 0:
                        qLokHp1.put(toQue)
                        speed = Vvalue(e.LokStop,5)
                        updateSignalWidgetSpeed(e.LokStop, speed) #speed wie getQueue
                        setVist(e.LokStop, speed)
                else:
                    print('nicht num. kein Lokstart')

    elif e.ST in range (30,32):         # Sh allein
        if Sad != 0:
            SerialIO.Wswitch(Sad,0)
        Draw.Shaspect(posX,posY,e.ST,e.Shstate,canvas)

            
                        
def SigChkR(posX,posY):
    e = Stp[posY][posX] 
    print('CheckR')
    print('Styp, StateHp, StateSh',e.ST,e.Hpstate,e.Shstate)
    
    Sad = e.DA

    if e.ST in range (26,30):       # Fall: Hp1, auch in Ranf auf Hp0
        if e.Hpstate == 'Hp1':
            e.Hpstate = 'Hp0'
            if Sad != 0:
                SerialIO.Wswitch(-Sad,0)
            Draw.HpAspect(posX,posY,e.ST,e.Hpstate,canvas)    

    if e.Shstate == 'Sh0':
        e.Shstate = 'Sh1'           
    else:
        e.Shstate = 'Sh0'            

    if e.Shstate == 'Sh0':
        Sad = -Sad

    if e.ST in range (26,28):                      # Hp mit Sh
        if Sad != 0:
            if e.Shstate == 'Sh1':                 # Fahrt                          
                if Sad < 0:                
                    SerialIO.Wswitch(-(abs(Sad)+1),0)  # Sh
                else:
                    SerialIO.Wswitch(Sad+1,0)
            else:                                  # Halt (Schaltreihenfolge tausch)
                if Sad < 0:                
                    SerialIO.Wswitch(-(abs(Sad)+1),0)  # Sh
                            
        Draw.ShHaspect(posX,posY,e.ST,e.Shstate,canvas)
    
    elif e.ST in range (30,32):                    # Sh
        if Sad != 0:
            SerialIO.Wswitch(Sad,0)
        Draw.Shaspect(posX,posY,e.ST,e.Shstate,canvas)

#----------------------------------------------------

def count_open_windows():
    #root = tk.Tk()
    open_windows = len(root.winfo_children())
    print(f"Anzahl der offenen Fenster: {open_windows}")
    #root.mainloop()
    return open_windows    

        

#----------------------------------------------------
# START

Platform = platform.system()
print("Platform",Platform)

if len(sys.argv) > 1:
    print('KmdZparam:',sys.argv[1])
    if sys.argv[1] == 'Bskip':
        Bskip = True                           # skip Haltfall Belegprüfung

ok,a,b,SerialPort,Adrconv = readSize()         # Size File     
if ok:
    print("Size x,y:",a,b)
    ElanzX = a
    ElanzY = b
    sx = ElanzX * elx + 2 * offsx
    sy = ElanzY * (ely+1) + offsy
    displaysize = sx, sy
   

root = tk.Tk()                  # Main window
root.resizable(0,0)
root.title(__file__)
canvas = tk.Canvas(root, width=displaysize[0], height=displaysize[1], bg=TABLE)
canvas.pack(expand=True)
canvas.pack_propagate(0)

os.environ['SDL_VIDEO_CENTERED'] = '1'  # window at center

if Platform == "Windows":
    font   = Font(family="Arial", size=9)
    fontm  = Font(family="Arial", size=9)
    font14 = Font(family="Arial", size=14)
    curfont = fontm #Windows    
elif Platform == "Linux":
    font   = Font(family="Arial", size=9)
    fontm  = Font(family="Arial", size=9)
    font14 = Font(family="Arial", size=14)
    curfont = font  #Raspberry
elif Platform == "Darwin":
    font   = Font(family="Arial", size=12)
    fontm  = Font(family="Arial", size=12)
    font14 = Font(family="Arial", size=14)
    curfont = font  #Mac
else:
    font   = Font(family="Arial", size=9)
    fontm  = Font(family="Arial", size=9)
    font14 = Font(family="Arial", size=14)
    curfont = fontm   


canvas.bind("<ButtonPress>", mouseButtonPressEvent)
canvas.bind("<Motion>", mouseMoveEvent)

root.bind("<Escape>", lambda x: mmcResetState(canvas))

root.protocol("WM_DELETE_WINDOW", frameOnClose)

clearAll()

print('try read lastfile here',lastpath)
loadlastfile()

root.bind("<<SerialIO_ReceivedEvent>>", frameOnSerialReceived)
root.bind("<<SerialIO_StateEvent>>", frameOnSerialState)
SerialIO = SerialIO_Class(root, SerialPort)
#print('>>>>>>>>>>>> type SerialIO:',type(SerialIO))
Draw.SetSerialIO(SerialIO)
root.after(0,TimerAfter)        #Begin Timer
root.mainloop()

# End File
